/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.helper;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.SimpleIntegerProperty;

public class ObservableArrayList<E>
extends ArrayList<E> {
    private SimpleIntegerProperty sizeProperty;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ObservableArrayList() {
        this.sizeProperty = new SimpleIntegerProperty(0);
    }

    public ObservableArrayList(int initialCapacity) {
        super(initialCapacity);
        this.sizeProperty = new SimpleIntegerProperty(0);
    }

    public ObservableArrayList(Collection<? extends E> c) {
        super(c);
        this.sizeProperty = new SimpleIntegerProperty(0);
    }

    @Override
    public boolean add(E e) {
        boolean returnValue = super.add(e);
        this.sizeProperty.set(this.size());
        this.propertyChangeSupport.firePropertyChange(this.sizeProperty.toString(), false, true);
        return returnValue;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.sizeProperty.set(this.size());
        this.propertyChangeSupport.firePropertyChange(this.sizeProperty.toString(), false, true);
    }

    @Override
    public E remove(int index) {
        Object returnValue = super.remove(index);
        this.sizeProperty.set(this.size());
        this.propertyChangeSupport.firePropertyChange(this.sizeProperty.toString(), false, true);
        return returnValue;
    }

    @Override
    public void clear() {
        super.clear();
        this.sizeProperty.set(this.size());
        this.propertyChangeSupport.firePropertyChange(this.sizeProperty.toString(), false, true);
    }

    @Override
    public boolean remove(Object o) {
        boolean returnValue = super.remove(o);
        if (returnValue) {
            this.sizeProperty.set(this.size());
            this.propertyChangeSupport.firePropertyChange(this.sizeProperty.toString(), false, true);
        }
        return returnValue;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

