/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate;

import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.AutoCalibrateHandler;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.helper.GeoLine;
import org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate.CalibrationErrorView;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;

public class AutoCalibrator {
    private PicLayerAbstract currentLayer;
    private List<Point2D> startPositions;
    private List<Point2D> endPositions;
    private double distance1To2;
    private double distance2To3;

    public AutoCalibrator() {
        this.currentLayer = null;
        this.startPositions = new ArrayList<Point2D>(3);
        this.endPositions = new ArrayList<Point2D>(3);
        this.distance1To2 = 0.0;
        this.distance2To3 = 0.0;
    }

    public AutoCalibrator(PicLayerAbstract abstractLayer, List<Point2D> startPoints, List<Point2D> endPoints, double distance12, double distance23) {
        this.currentLayer = abstractLayer;
        this.startPositions = startPoints;
        this.endPositions = endPoints;
        this.distance1To2 = distance12;
        this.distance2To3 = distance23;
    }

    public void calibrate() {
        List<Point2D> startPointList = this.currentLayer.getTransformer().getOriginPoints();
        List<Point2D> endPointList = this.correctedPoints(this.endPositions, this.distance1To2, this.distance2To3);
        if (this.currentLayer != null && startPointList != null && endPointList != null && startPointList.size() == 3 && endPointList.size() == 3 && this.distance1To2 != 0.0 && this.distance2To3 != 0.0) {
            for (Point2D endPos : endPointList) {
                int index = endPointList.indexOf(endPos);
                Point2D tsPoint = startPointList.get(index);
                Point2D tePoint = this.translatePointToCurrentScale(endPos);
                this.currentLayer.getTransformer().updatePair(tsPoint, tePoint);
            }
            if (!this.checkCalibration(this.startPositions, endPointList)) {
                this.currentLayer.getTransformer().resetCalibration();
                this.showErrorView(CalibrationErrorView.DIMENSION_ERROR);
            }
        } else {
            this.showErrorView(CalibrationErrorView.CALIBRATION_ERROR);
        }
    }

    private boolean checkCalibration(List<Point2D> list, List<Point2D> compareList) {
        if (list.size() != 3 || compareList.size() != 3) {
            return false;
        }
        double dist12 = new GeoLine(list.get(0), list.get(1)).getDistance();
        double dist23 = new GeoLine(list.get(1), list.get(2)).getDistance();
        double dist13 = new GeoLine(list.get(0), list.get(2)).getDistance();
        double[] startRatio = new double[]{1.0, dist23 / dist12, dist13 / dist12};
        double compDist12 = new GeoLine(compareList.get(0), compareList.get(1)).getDistance();
        double compDist23 = new GeoLine(compareList.get(1), compareList.get(2)).getDistance();
        double compDist13 = new GeoLine(compareList.get(0), compareList.get(2)).getDistance();
        double[] compRatio = new double[]{1.0, compDist23 / compDist12, compDist13 / compDist12};
        double epsilon = 0.5;
        return compRatio[1] >= startRatio[1] - epsilon && compRatio[1] <= startRatio[1] + epsilon && compRatio[2] >= startRatio[2] - epsilon && compRatio[2] <= startRatio[2] + epsilon;
    }

    private List<Point2D> correctedPoints(List<Point2D> points, double distance12, double distance23) {
        if (points != null && points.size() == 3) {
            ArrayList<Point2D> correctedList = new ArrayList<Point2D>();
            GeoLine line12 = new GeoLine(points.get(0), points.get(1));
            GeoLine line23 = new GeoLine(points.get(1), points.get(2));
            correctedList.add(points.get(0));
            correctedList.add(line12.pointOnLine(distance12));
            double lonOffset = line12.pointOnLine(distance12).getX() - points.get(1).getX();
            double latOffset = line12.pointOnLine(distance12).getY() - points.get(1).getY();
            Point2D pointOnLine23 = line23.pointOnLine(distance23);
            Point2D.Double correctedPointOnLine23 = new Point2D.Double(pointOnLine23.getX() + lonOffset, pointOnLine23.getY() + latOffset);
            correctedList.add(correctedPointOnLine23);
            return correctedList;
        }
        return null;
    }

    private Point2D translatePointToCurrentScale(Point2D point) {
        Point2D translatedPoint = null;
        LatLon ll = new LatLon(point.getY(), point.getX());
        MapViewState.MapViewPoint en = MainApplication.getMap().mapView.getState().getPointFor(ll);
        try {
            translatedPoint = this.currentLayer.transformPoint(new Point2D.Double(en.getInViewX(), en.getInViewY()));
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        return translatedPoint;
    }

    public void showErrorView(String msg) {
        AutoCalibrateHandler handler = new AutoCalibrateHandler();
        handler.getErrorView().show(msg);
    }

    public void setCurrentLayer(PicLayerAbstract currentLayer) {
        this.currentLayer = currentLayer;
    }

    public void setStartPositions(List<Point2D> startPositions) {
        this.startPositions = startPositions;
    }

    public void setEndPositions(List<Point2D> endPositions) {
        this.endPositions = endPositions;
    }

    public void setDistance1To2(double distance12) {
        this.distance1To2 = distance12;
    }

    public void setDistance2To3(double distance23) {
        this.distance2To3 = distance23;
    }
}

