/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.layer;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class PicLayerFromFile
extends PicLayerAbstract {
    private File m_file;
    private boolean isZip;
    private String imgNameInZip;
    private String m_tooltiptext;

    public PicLayerFromFile(File file) {
        this.m_file = file;
        if ("zip".equalsIgnoreCase(PicLayerFromFile.getFileExtension(file))) {
            this.isZip = true;
        }
        this.m_tooltiptext = this.m_file.getAbsolutePath();
        this.setName(this.m_file.getName());
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Image createImage() throws IOException {
        if (this.isZip) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ZipFile zipFile = new ZipFile(this.m_file);){
                    ZipEntry imgEntry = null;
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    String[] supportedImageExtensions = ImageIO.getReaderFormatNames();
                    block13: while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String[] stringArray = supportedImageExtensions;
                        int n = supportedImageExtensions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String extension = stringArray[n2];
                            if (entry.getName().endsWith("." + extension)) {
                                imgEntry = entry;
                                break block13;
                            }
                            ++n2;
                        }
                    }
                    if (imgEntry != null) {
                        BufferedImage bufferedImage;
                        InputStream is;
                        Throwable throwable2;
                        block26: {
                            this.imgNameInZip = imgEntry.getName();
                            throwable2 = null;
                            Object var8_12 = null;
                            is = zipFile.getInputStream(imgEntry);
                            bufferedImage = ImageIO.read(is);
                            if (is == null) break block26;
                            is.close();
                        }
                        return bufferedImage;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                    } else if (throwable2 != throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    Logging.warn((String)"Warning: no image in zip file found");
                    return null;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Logging.warn((String)I18n.tr((String)"Warning: failed to handle zip file ''{0}''. Exception was: {1}", (Object[])new Object[]{this.m_file.getName(), e.toString()}));
                return null;
            }
        }
        return ImageIO.read(this.m_file);
    }

    @Override
    protected void lookForCalibration() throws IOException {
        block26: {
            String[][] imgExtensions = new String[][]{{".jpg", ".jpeg"}, {".png"}, {".tif", ".tiff"}, {".bmp"}};
            String[][] wldExtensions = new String[][]{{".wld", ".jgw", ".jpgw"}, {".wld", ".pgw", ".pngw"}, {".wld", ".tfw", ".tifw"}, {".wld", ".bmpw", ".bpw"}};
            if (this.isZip) {
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (ZipFile zipFile = new ZipFile(this.m_file);){
                        String calFileStr = String.valueOf(this.imgNameInZip) + ".cal";
                        ZipEntry calEntry = zipFile.getEntry(calFileStr);
                        if (calEntry != null) {
                            if (this.confirmCalibrationLoading(calFileStr)) {
                                InputStream is = zipFile.getInputStream(calEntry);
                                this.loadCalibration(is);
                                return;
                            }
                            break block26;
                        }
                        int dotIdx = this.imgNameInZip.lastIndexOf(".");
                        if (dotIdx == -1) {
                            return;
                        }
                        String extension = this.imgNameInZip.substring(dotIdx);
                        String namepart = this.imgNameInZip.substring(0, dotIdx);
                        int i = 0;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Logging.warn((String)I18n.tr((String)"Warning: failed to handle zip file ''{0}''. Exception was: {1}", (Object[])new Object[]{this.m_file.getName(), e.toString()}));
                    return;
                }
            }
            File calFile = new File(this.m_file + ".cal");
            if (calFile.exists()) {
                if (this.confirmCalibrationLoading(calFile.getName())) {
                    this.loadCalibration(new FileInputStream(calFile));
                }
            } else {
                int dotIdx = this.m_file.getName().lastIndexOf(".");
                if (dotIdx == -1) {
                    return;
                }
                String extension = this.m_file.getName().substring(dotIdx);
                String namepart = this.m_file.getName().substring(0, dotIdx);
                int i = 0;
                while (i < imgExtensions.length) {
                    if (Arrays.asList(imgExtensions[i]).contains(extension.toLowerCase())) {
                        String[] stringArray = wldExtensions[i];
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String wldExtension = stringArray[n2];
                            File wldFile = new File(this.m_file.getParentFile(), String.valueOf(namepart) + wldExtension);
                            if (wldFile.exists()) {
                                this.loadWorldfile(new FileInputStream(wldFile));
                                return;
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean confirmCalibrationLoading(String fileName) {
        String prefkey = "piclayer.autoloadcal";
        String policy = Config.getPref().get(prefkey, "");
        policy = policy.trim().toLowerCase();
        boolean loadcal = false;
        String msg = I18n.tr((String)"A calibration file associated to the picture file was found: {0}\n", (Object[])new Object[]{fileName});
        if (policy.equals("yes")) {
            loadcal = true;
        } else if (policy.equals("no")) {
            loadcal = false;
        } else if (policy.equals("ask")) {
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"Set \"{0}\" to yes/no/ask in the preferences\nto control the autoloading of calibration files.", (Object[])new Object[]{prefkey});
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"Do you want to apply it ?", (Object[])new Object[0]);
            int answer = JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), msg, I18n.tr((String)"Load calibration file?", (Object[])new Object[0]), 0);
            if (answer == 0) {
                loadcal = true;
            }
        } else {
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"It will be applied automatically.", (Object[])new Object[0]);
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"Also, from now on, calibration files will always be loaded automatically.", (Object[])new Object[0]);
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"Set \"{0}\" to yes/no/ask in the preferences\nto control the autoloading of calibration files.", (Object[])new Object[]{prefkey});
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), msg, "Automatic loading of the calibration", 1);
            Config.getPref().put(prefkey, "yes");
            loadcal = true;
        }
        return loadcal;
    }

    @Override
    public String getPicLayerName() {
        return this.m_tooltiptext;
    }

    public static String getFileExtension(File f) {
        int dotIdx = f.getName().lastIndexOf(46);
        if (dotIdx == -1) {
            return "";
        }
        return f.getName().substring(dotIdx + 1);
    }

    public static class CalData {
        public String[] imgExt;
        public String[] calExt;
        public CalibrationType type;

        public CalData(String[] imgExt, String[] calExt, CalibrationType type) {
            this.imgExt = imgExt;
            this.calExt = calExt;
            this.type = type;
        }
    }

    public static enum CalibrationType {
        CAL,
        WORLDFILE;

    }
}

