/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openstreetmap.josm.tools.I18n;

public class CalibrationWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int FILES_ONLY = 0;
    private JFileChooser fileChooser = new JFileChooser();
    private String referenceFileName = null;
    private List<Point2D> originPoints;
    private List<Point2D> referencePoints;
    private String dist1Value;
    private String dist2Value;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel infoBar;
    private JPanel buttonBar;
    private JButton addRefPointsButton;
    private JButton addEdgePointsButton;
    private JButton helpButton;
    private JButton openButton;
    private JButton runButton;
    private JButton cancelButton;
    private JLabel infoHeader;
    private JLabel edgePointHeader;
    private JLabel edgePointNames;
    private JLabel edgePointValues;
    private JLabel distanceHeader;
    private JLabel distance1;
    private JLabel distance2;
    private JTextField distance1Field;
    private JTextField distance2Field;
    private JLabel distance1Value;
    private JLabel distance2Value;
    private JLabel refFileHeader;
    private JLabel refFileName;
    private JLabel refFileNameValue;
    private JLabel refPointHeader;
    private JLabel refPointNames;
    private JLabel refPointValues;
    private JLabel edgePointsChecked;
    private JLabel distance1Checked;
    private JLabel distance2Checked;
    private JLabel fileChecked;
    private JLabel refPointsChecked;

    public CalibrationWindow() {
        this.setFileChooser();
        this.originPoints = new ArrayList<Point2D>();
        this.referencePoints = new ArrayList<Point2D>();
        this.dist1Value = null;
        this.dist2Value = null;
        this.initComponents();
        this.updateState();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.infoBar = new JPanel();
        this.buttonBar = new JPanel();
        this.addRefPointsButton = new JButton();
        this.addEdgePointsButton = new JButton();
        this.helpButton = new JButton();
        this.openButton = new JButton();
        this.runButton = new JButton();
        this.cancelButton = new JButton();
        this.infoHeader = new JLabel();
        this.edgePointHeader = new JLabel();
        this.edgePointNames = new JLabel();
        this.edgePointValues = new JLabel();
        this.distanceHeader = new JLabel();
        this.distance1 = new JLabel();
        this.distance2 = new JLabel();
        this.distance1Field = new JTextField();
        this.distance2Field = new JTextField();
        this.distance1Value = new JLabel();
        this.distance2Value = new JLabel();
        this.refFileHeader = new JLabel();
        this.refFileName = new JLabel();
        this.refFileNameValue = new JLabel();
        this.refPointHeader = new JLabel();
        this.refPointNames = new JLabel();
        this.refPointValues = new JLabel();
        this.edgePointsChecked = new JLabel();
        this.distance1Checked = new JLabel();
        this.distance2Checked = new JLabel();
        this.fileChecked = new JLabel();
        this.refPointsChecked = new JLabel();
        this.setTitle(I18n.tr((String)"AutoCalibration", (Object[])new Object[0]));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(50, 100));
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.setInfoBar();
        this.setInfoHeader();
        this.dialogPane.add((Component)this.infoBar, "North");
        this.setContentPanel();
        this.setPointHeader();
        this.setEdgePointNamesValues();
        this.setDistanceHeader();
        this.setDistance1();
        this.setDistance1Field();
        this.setDistance2();
        this.setDistance2Field();
        this.setRefFileHeader();
        this.setRefFileName();
        this.setOpenButton();
        this.setRefPointHeader();
        this.setRefPointNamesValues();
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.setButtonBar();
        this.setOKButton();
        this.setCancelButton();
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void setInfoBar() {
        this.infoBar.setBorder(new EmptyBorder(0, 0, 12, 0));
        this.infoBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.infoBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.infoBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
    }

    private void setInfoHeader() {
        this.infoHeader.setText(I18n.tr((String)"<html>Please enter the required information.</html>", (Object[])new Object[0]));
        this.infoBar.add((Component)this.infoHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        String space = "     ";
        this.helpButton = new JButton(I18n.tr((String)(space + "help" + space), (Object[])new Object[0]));
        this.infoBar.add((Component)this.helpButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setContentPanel() {
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setBackground(new Color(200, 200, 200));
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
    }

    private void setPointHeader() {
        this.edgePointHeader.setText(I18n.tr((String)"<html><b><u>Local Edge Points</u></b></html>", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.edgePointHeader, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
    }

    private void setEdgePointNamesValues() {
        this.edgePointNames.setText(I18n.tr((String)"<html>Point 1 (Lat,Lon):<br>Point 2 (Lat,Lon):<br>Point 3 (Lat,Lon):<br></html>", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.edgePointNames, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
        if (!this.originPoints.isEmpty()) {
            this.edgePointValuesEntered();
        } else {
            this.addEdgePointsButton = new JButton(I18n.tr((String)"Add Points...", (Object[])new Object[0]));
            this.contentPanel.add((Component)this.addEdgePointsButton, new GridBagConstraints(3, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 50, 5, 5), 0, 0));
        }
    }

    private void setDistanceHeader() {
        this.distanceHeader.setText(I18n.tr((String)"<html><b><u>True Distances</u></b></html>", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.distanceHeader, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
    }

    private void setDistance1Field() {
        this.distance1Field.setText("Click here...");
        this.contentPanel.add((Component)this.distance1Field, new GridBagConstraints(3, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 50, 5, 5), 0, 0));
    }

    private void setDistance2() {
        this.distance2.setText(I18n.tr((String)"Point 2 to Point 3 (meter):", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.distance2, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
    }

    private void setDistance2Field() {
        this.distance2Field.setText("Click here...");
        this.contentPanel.add((Component)this.distance2Field, new GridBagConstraints(3, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 50, 5, 5), 0, 0));
    }

    private void setRefFileHeader() {
        this.refFileHeader.setText(I18n.tr((String)"<html><b><u>Reference File</u></b></html>", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.refFileHeader, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
    }

    private void setRefFileName() {
        this.refFileName.setText(I18n.tr((String)"<html>File Name:<br><br><br></html>", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.refFileName, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
    }

    private void setOpenButton() {
        String imageName = "open.png";
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/" + imageName));
        }
        catch (Exception ex) {
            System.out.println("Error: Could not load image " + imageName + "," + ex);
        }
        this.openButton = new JButton(I18n.tr((String)"Open a File...", (Object[])new Object[0]));
        this.openButton.setIcon(new ImageIcon(image));
        this.contentPanel.add((Component)this.openButton, new GridBagConstraints(3, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 50, 5, 5), 0, 0));
    }

    private void setRefPointHeader() {
        this.refPointHeader.setText("<html><b><u>Reference Points</u></b></html>\"");
        this.contentPanel.add((Component)this.refPointHeader, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
    }

    private void setRefPointNamesValues() {
        Point2D rp1 = null;
        Point2D rp2 = null;
        Point2D rp3 = null;
        if (!this.referencePoints.isEmpty()) {
            rp1 = this.referencePoints.get(0);
            rp2 = this.referencePoints.get(1);
            rp3 = this.referencePoints.get(2);
        }
        this.refPointNames.setText(I18n.tr((String)"<html>Point 1 (Lat,Lon):<br>Point 2 (Lat,Lon):<br>Point 3 (Lat,Lon):<br></html>", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.refPointNames, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
        if (!this.referencePoints.isEmpty()) {
            this.refPointValues.setText(I18n.tr((String)("<html>" + rp1.getY() + ", " + rp1.getX() + "<br>" + rp2.getY() + ", " + rp2.getX() + "<br>" + rp3.getY() + ", " + rp3.getX() + "<br></html>"), (Object[])new Object[0]));
            this.contentPanel.add((Component)this.refPointValues, new GridBagConstraints(3, 8, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
        } else {
            this.addRefPointsButton = new JButton(I18n.tr((String)"Add Points...", (Object[])new Object[0]));
            this.contentPanel.add((Component)this.addRefPointsButton, new GridBagConstraints(3, 8, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 50, 5, 5), 0, 0));
        }
    }

    private void setButtonBar() {
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
    }

    private void setOKButton() {
        this.runButton.setText(I18n.tr((String)"Run", (Object[])new Object[0]));
        this.buttonBar.add((Component)this.runButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
    }

    private void setCancelButton() {
        this.cancelButton.setText(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void edgePointValuesEntered() {
        Point2D p1 = null;
        Point2D p2 = null;
        Point2D p3 = null;
        DecimalFormat df = new DecimalFormat("###.###");
        if (this.originPoints.size() != 3) {
            return;
        }
        p1 = this.originPoints.get(0);
        p2 = this.originPoints.get(1);
        p3 = this.originPoints.get(2);
        this.edgePointValues.setText(I18n.tr((String)("<html>" + df.format(p1.getY()) + ", " + df.format(p1.getX()) + "<br>" + df.format(p2.getY()) + ", " + df.format(p2.getX()) + "<br>" + df.format(p3.getY()) + ", " + df.format(p3.getX()) + "<br></html>"), (Object[])new Object[0]));
        this.contentPanel.remove(this.addEdgePointsButton);
        this.contentPanel.add((Component)this.edgePointValues, new GridBagConstraints(3, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
        this.edgePointsChecked.setIcon(this.getCheckedIcon());
        this.contentPanel.add((Component)this.edgePointsChecked, new GridBagConstraints(6, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void distance1Entered() {
        this.contentPanel.remove(this.distance1Field);
        this.distance1Value.setText(this.dist1Value);
        this.contentPanel.add((Component)this.distance1Value, new GridBagConstraints(3, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
        this.distance1Checked.setIcon(this.getCheckedIcon());
        this.contentPanel.add((Component)this.distance1Checked, new GridBagConstraints(6, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void distance2Entered() {
        this.contentPanel.remove(this.distance2Field);
        this.distance2Value.setText(this.dist2Value);
        this.contentPanel.add((Component)this.distance2Value, new GridBagConstraints(3, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
        this.distance2Checked.setIcon(this.getCheckedIcon());
        this.contentPanel.add((Component)this.distance2Checked, new GridBagConstraints(6, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void refFileEntered() {
        this.contentPanel.remove(this.openButton);
        this.refFileName.setText(I18n.tr((String)"<html>File Name:</html>", (Object[])new Object[0]));
        this.refFileNameValue.setText(this.referenceFileName);
        this.contentPanel.add((Component)this.refFileNameValue, new GridBagConstraints(3, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
        this.fileChecked.setIcon(this.getCheckedIcon());
        this.contentPanel.add((Component)this.fileChecked, new GridBagConstraints(6, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void refPointValuesEntered() {
        Point2D p1 = null;
        Point2D p2 = null;
        Point2D p3 = null;
        DecimalFormat df = new DecimalFormat("###.###");
        if (this.referencePoints.size() != 3) {
            return;
        }
        p1 = this.referencePoints.get(0);
        p2 = this.referencePoints.get(1);
        p3 = this.referencePoints.get(2);
        this.refPointValues.setText(I18n.tr((String)("<html>" + df.format(p1.getY()) + ", " + df.format(p1.getX()) + "<br>" + df.format(p2.getY()) + ", " + df.format(p2.getX()) + "<br>" + df.format(p3.getY()) + ", " + df.format(p3.getX()) + "<br></html>"), (Object[])new Object[0]));
        this.contentPanel.remove(this.addRefPointsButton);
        this.contentPanel.add((Component)this.refPointValues, new GridBagConstraints(3, 8, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
        this.refPointsChecked.setIcon(this.getCheckedIcon());
        this.contentPanel.add((Component)this.refPointsChecked, new GridBagConstraints(6, 8, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setDistance1() {
        this.distance1.setText(I18n.tr((String)"Point 1 to Point 2 (meter):", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.distance1, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 30), 0, 0));
    }

    public JButton getOpenButton() {
        return this.openButton;
    }

    public JTextField getDistance1Field() {
        return this.distance1Field;
    }

    public JTextField getDistance2Field() {
        return this.distance2Field;
    }

    public String getDistance1FieldText() {
        return this.distance1Field.getText();
    }

    public String getDistance2FieldText() {
        return this.distance2Field.getText();
    }

    public void setOriginPoints(List<Point2D> points) {
        this.originPoints = points;
        this.edgePointValuesEntered();
        this.updateState();
    }

    public void setReferencePoints(List<Point2D> points) {
        this.referencePoints = points;
        this.refPointValuesEntered();
        this.updateState();
    }

    public void setDistance1Field(String s) {
        this.distance1Field.setText(s);
        this.updateState();
    }

    public void setDistance2Field(String s) {
        this.distance2Field.setText(s);
        this.updateState();
    }

    public void setDistance1Value(String valueAsString) {
        this.dist1Value = valueAsString;
        if (!valueAsString.equals("")) {
            this.distance1Entered();
        }
        this.updateState();
    }

    public void setDistance2Value(String valueAsString) {
        this.dist2Value = valueAsString;
        if (!valueAsString.equals("")) {
            this.distance2Entered();
        }
        this.updateState();
    }

    public void setOkButtonListener(ActionListener l) {
        this.runButton.addActionListener(l);
    }

    public void setCancelButtonListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    public void setWindowListener(WindowListener l) {
        this.addWindowListener(l);
    }

    public void setReferenceFileName(String name) {
        this.referenceFileName = name;
    }

    private void setFileChooser() {
        this.fileChooser.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(".osm, .gpx", "osm", "gpx");
        this.fileChooser.setFileFilter(filter);
    }

    public void setReferenceFileNameValue(String value) {
        this.referenceFileName = value;
        this.refFileNameValue.setText(value);
        this.refFileEntered();
        this.updateState();
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public String getFileName() {
        return this.referenceFileName;
    }

    public void addOpenFileButtonListener(ActionListener l) {
        this.openButton.addActionListener(l);
    }

    public void addCancelButtonListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    public void addRunButtonListener(ActionListener l) {
        this.runButton.addActionListener(l);
    }

    public void addEdgePointButtonListener(ActionListener l) {
        this.addEdgePointsButton.addActionListener(l);
    }

    public void addReferencePointButtonListener(ActionListener l) {
        this.addRefPointsButton.addActionListener(l);
    }

    public void addFrameWindowListener(WindowAdapter wAdapter) {
        this.addWindowListener(wAdapter);
    }

    public void addDistance1FieldListener(FocusListener l) {
        this.distance1Field.addFocusListener(l);
    }

    public void addDistance2FieldListener(FocusListener l) {
        this.distance2Field.addFocusListener(l);
    }

    public void addHelpButtonListener(ActionListener l) {
        this.helpButton.addActionListener(l);
    }

    private ImageIcon getCheckedIcon() {
        String imageName = "checked.png";
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/" + imageName));
        }
        catch (Exception ex) {
            System.out.println("Error: Could not load image " + imageName + "," + ex);
        }
        return new ImageIcon(image);
    }

    public void updateState() {
        if (this.originPoints.isEmpty()) {
            this.distance1Field.setEnabled(false);
            this.distance2Field.setEnabled(false);
            this.openButton.setEnabled(false);
            this.addRefPointsButton.setEnabled(false);
            this.runButton.setEnabled(false);
        } else {
            if (this.dist1Value == null && this.dist2Value == null) {
                this.distance1Field.setEnabled(true);
                this.distance2Field.setEnabled(true);
            }
            if (this.dist1Value != null) {
                this.openButton.setEnabled(true);
            }
            if (this.referenceFileName != null) {
                this.addRefPointsButton.setEnabled(true);
            }
            if (!this.referencePoints.isEmpty()) {
                this.runButton.setEnabled(true);
            }
        }
    }

    public void refresh() {
        this.setVisible(true);
    }
}

