/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.piclayer.actions.SavePictureCalibrationAction;
import org.openstreetmap.josm.plugins.piclayer.actions.newlayer.NewLayerFromClipboardAction;
import org.openstreetmap.josm.plugins.piclayer.actions.newlayer.NewLayerFromFileAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.MovePictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.RotatePictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleXPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleXYPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleYPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ShearPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.MovePointAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.RemovePointAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.TransformPointAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.AutoCalibratePictureAction;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class PicLayerPlugin
extends Plugin
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    public static List<IconToggleButton> buttonList = null;
    JosmAction newLayerFromFileAction = new NewLayerFromFileAction();
    JosmAction newLayerFromClipboardAction = new NewLayerFromClipboardAction();

    public PicLayerPlugin(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)MainApplication.getMenu().imagerySubMenu, (JosmAction)this.newLayerFromFileAction);
        MainMenu.add((JMenu)MainApplication.getMenu().imagerySubMenu, (JosmAction)this.newLayerFromClipboardAction);
        this.updateEnabledState();
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            MovePictureAction movePictureAction = new MovePictureAction();
            MovePointAction movePointAction = new MovePointAction();
            TransformPointAction transformPointAction = new TransformPointAction();
            RemovePointAction removePointAction = new RemovePointAction();
            RotatePictureAction rotatePictureAction = new RotatePictureAction();
            ScaleXYPictureAction scaleXYPictureAction = new ScaleXYPictureAction();
            ScaleXPictureAction scaleXPictureAction = new ScaleXPictureAction();
            ScaleYPictureAction scaleYPictureAction = new ScaleYPictureAction();
            ShearPictureAction shearPictureAction = new ShearPictureAction();
            AutoCalibratePictureAction autoCalibratePictureAction = new AutoCalibratePictureAction();
            buttonList = new ArrayList<IconToggleButton>(7);
            buttonList.add(this.picLayerActionButtonFactory(movePictureAction));
            buttonList.add(this.picLayerActionButtonFactory(movePointAction));
            buttonList.add(this.picLayerActionButtonFactory(transformPointAction));
            buttonList.add(this.picLayerActionButtonFactory(removePointAction));
            buttonList.add(this.picLayerActionButtonFactory(rotatePictureAction));
            buttonList.add(this.picLayerActionButtonFactory(scaleXYPictureAction));
            buttonList.add(this.picLayerActionButtonFactory(scaleXPictureAction));
            buttonList.add(this.picLayerActionButtonFactory(scaleYPictureAction));
            buttonList.add(this.picLayerActionButtonFactory(shearPictureAction));
            buttonList.add(this.picLayerActionButtonFactory(autoCalibratePictureAction));
            for (IconToggleButton btn : buttonList) {
                newFrame.addMapMode(btn);
            }
        }
    }

    private IconToggleButton picLayerActionButtonFactory(MapMode action) {
        IconToggleButton button = new IconToggleButton((Action)action);
        button.setAutoHideDisabledButton(true);
        return button;
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        Layer oldLayer = e.getPreviousActiveLayer();
        Layer newLayer = MainApplication.getLayerManager().getActiveLayer();
        boolean oldPic = oldLayer instanceof PicLayerAbstract;
        boolean newPic = newLayer instanceof PicLayerAbstract;
        if (oldPic) {
            ((PicLayerAbstract)oldLayer).setDrawOriginPoints(false);
        }
        if (newPic) {
            ((PicLayerAbstract)newLayer).setDrawOriginPoints(true);
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        this.newLayerFromFileAction.setEnabled(true);
        this.newLayerFromClipboardAction.setEnabled(true);
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof PicLayerAbstract && ((PicLayerAbstract)e.getRemovedLayer()).getTransformer().isModified() && JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Do you want to save current calibration of layer {0}?", (Object[])new Object[]{((PicLayerAbstract)e.getRemovedLayer()).getPicLayerName()}), I18n.tr((String)"Select an option", (Object[])new Object[0]), 0) == 0) {
            new SavePictureCalibrationAction((PicLayerAbstract)e.getRemovedLayer()).actionPerformed(null);
        }
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        boolean enable = !MainApplication.getLayerManager().getLayers().isEmpty();
        this.newLayerFromFileAction.setEnabled(enable);
        this.newLayerFromClipboardAction.setEnabled(enable);
    }
}

