/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

final class DataSetCommandMerger {
    private final ConflictCollection conflicts = new ConflictCollection();
    private final DataSet sourceDataSet;
    private final DataSet targetDataSet;
    private final List<Command> cmds = new LinkedList<Command>();
    private final List<OsmPrimitive> nominalRevertedPrimitives = new LinkedList<OsmPrimitive>();

    DataSetCommandMerger(DataSet sourceDataSet, DataSet targetDataSet) {
        this.sourceDataSet = sourceDataSet;
        this.targetDataSet = targetDataSet;
        this.merge();
    }

    private void addChangeCommandIfNotEquals(OsmPrimitive target, OsmPrimitive newTarget, boolean nominal) {
        if (!target.hasEqualSemanticAttributes(newTarget)) {
            this.cmds.add((Command)new ChangeCommand(target, newTarget));
            if (nominal) {
                this.nominalRevertedPrimitives.add(target);
            }
            Logging.debug((String)("Reverting " + target + " to " + newTarget));
        }
    }

    private OsmPrimitive getMergeTarget(OsmPrimitive mergeSource) {
        OsmPrimitive p = (OsmPrimitive)this.targetDataSet.getPrimitiveById(mergeSource.getId(), mergeSource.getType());
        if (p == null) {
            throw new IllegalStateException(I18n.tr((String)"Missing merge target for {0}", (Object[])new Object[]{mergeSource.getPrimitiveId()}));
        }
        return p;
    }

    private static void mergePrimitive(OsmPrimitive source, OsmPrimitive target, OsmPrimitive newTarget) {
        newTarget.mergeFrom(source);
        newTarget.setOsmId(target.getId(), target.getVersion());
        newTarget.setVisible(target.isVisible());
        newTarget.setDeleted(false);
    }

    private void mergeNode(Node source) {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Node target = (Node)this.getMergeTarget((OsmPrimitive)source);
        Node newTarget = new Node(target);
        DataSetCommandMerger.mergePrimitive((OsmPrimitive)source, (OsmPrimitive)target, (OsmPrimitive)newTarget);
        this.addChangeCommandIfNotEquals((OsmPrimitive)target, (OsmPrimitive)newTarget, true);
    }

    private void mergeWay(Way source) {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Way target = (Way)this.getMergeTarget((OsmPrimitive)source);
        LinkedHashSet<Conflict> localConflicts = new LinkedHashSet<Conflict>();
        ArrayList<Node> newNodes = new ArrayList<Node>(source.getNodesCount());
        for (Node sourceNode : source.getNodes()) {
            Node targetNode = (Node)this.getMergeTarget((OsmPrimitive)sourceNode);
            if (!targetNode.isDeleted() || this.nominalRevertedPrimitives.contains(targetNode)) {
                newNodes.add(targetNode);
                continue;
            }
            if (sourceNode.isIncomplete() && !this.conflicts.hasConflictForMy((OsmPrimitive)targetNode)) {
                localConflicts.add(new Conflict((OsmPrimitive)targetNode, (OsmPrimitive)sourceNode, true));
                continue;
            }
            Logging.info((String)("Skipping target node " + targetNode + " for source node " + sourceNode + " while reverting way " + source));
        }
        Way newTarget = new Way(target);
        DataSetCommandMerger.mergePrimitive((OsmPrimitive)source, (OsmPrimitive)target, (OsmPrimitive)newTarget);
        newTarget.setNodes(newNodes);
        if (newNodes.isEmpty()) {
            Logging.error((String)("Unable to revert " + source + " as it produces 0 nodes way " + newTarget));
        } else {
            for (Conflict c : localConflicts) {
                Logging.warn((String)("New conflict: " + c));
                this.conflicts.add(c);
                Node targetNode = (Node)c.getTheir();
                Node undeletedTargetNode = new Node(targetNode);
                undeletedTargetNode.setDeleted(false);
                this.addChangeCommandIfNotEquals((OsmPrimitive)targetNode, (OsmPrimitive)undeletedTargetNode, false);
            }
            this.addChangeCommandIfNotEquals((OsmPrimitive)target, (OsmPrimitive)newTarget, true);
        }
    }

    private void mergeRelation(Relation source) {
        if (source.isIncomplete()) {
            return;
        }
        if (!source.isVisible()) {
            return;
        }
        Relation target = (Relation)this.getMergeTarget((OsmPrimitive)source);
        LinkedList<RelationMember> newMembers = new LinkedList<RelationMember>();
        for (RelationMember sourceMember : source.getMembers()) {
            OsmPrimitive targetMember = this.getMergeTarget(sourceMember.getMember());
            if (targetMember.isDeleted() && sourceMember.getMember().isIncomplete() && !this.conflicts.hasConflictForMy(targetMember)) {
                Node undeletedTargetMember;
                this.conflicts.add(new Conflict(targetMember, sourceMember.getMember(), true));
                switch (targetMember.getType()) {
                    case NODE: {
                        undeletedTargetMember = new Node((Node)targetMember);
                        break;
                    }
                    case WAY: {
                        undeletedTargetMember = new Way((Way)targetMember);
                        break;
                    }
                    case RELATION: {
                        undeletedTargetMember = new Relation((Relation)targetMember);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                undeletedTargetMember.setDeleted(false);
                this.addChangeCommandIfNotEquals(targetMember, (OsmPrimitive)undeletedTargetMember, false);
            }
            newMembers.add(new RelationMember(sourceMember.getRole(), targetMember));
        }
        Relation newRelation = new Relation(target);
        DataSetCommandMerger.mergePrimitive((OsmPrimitive)source, (OsmPrimitive)target, (OsmPrimitive)newRelation);
        newRelation.setMembers(newMembers);
        this.addChangeCommandIfNotEquals((OsmPrimitive)target, (OsmPrimitive)newRelation, true);
    }

    private void merge() {
        for (Node node : this.sourceDataSet.getNodes()) {
            this.mergeNode(node);
        }
        for (Way way : this.sourceDataSet.getWays()) {
            this.mergeWay(way);
        }
        ArrayList<Relation> withRelationsMembers = new ArrayList<Relation>();
        for (Relation relation : this.sourceDataSet.getRelations()) {
            if (relation.getMemberPrimitives(Relation.class).isEmpty()) {
                this.mergeRelation(relation);
                continue;
            }
            withRelationsMembers.add(relation);
        }
        withRelationsMembers.forEach(this::mergeRelation);
    }

    public List<Command> getCommandList() {
        return this.cmds;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }
}

