/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.spreadsheet.Column;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.TableCalcNode;
import org.jopendocument.dom.spreadsheet.TableStyle;
import org.jopendocument.util.Tuple2;

public class Table<D extends ODDocument>
extends TableCalcNode<TableStyle, D> {
    private final List<Row<D>> rows = new ArrayList<Row<D>>();
    private final List<Column<D>> cols = new ArrayList<Column<D>>();

    static final String getName(Element element) {
        return element.getAttributeValue("name", element.getNamespace("table"));
    }

    public Table(D d, Element element) {
        super(d, element, TableStyle.class);
        this.readColumns();
        this.readRows();
    }

    private void readColumns() {
        this.read(true);
    }

    private final void readRows() {
        this.read(false);
    }

    private final void read(boolean bl) {
        Tuple2<List<Element>, Integer> tuple2 = this.flatten(bl);
        (bl ? this.cols : this.rows).clear();
        for (Element element : tuple2.get0()) {
            if (bl) {
                this.addCol(element);
                continue;
            }
            this.addRow(element);
        }
    }

    private final void addCol(Element element) {
        this.cols.add(new Column(this, element));
    }

    private Tuple2<List<Element>, Integer> flatten(boolean bl) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this.getElement().getChild("table-header-" + this.getName(bl) + "s", this.getTABLE());
        if (element != null) {
            arrayList.addAll(this.flatten(element, bl));
        }
        int n = arrayList.size();
        arrayList.addAll(this.flatten(this.getElement(), bl));
        return Tuple2.create(arrayList, n);
    }

    private List<Element> flatten(Element element, boolean bl) {
        String string = this.getName(bl);
        List list = element.getChildren("table-" + string, this.getTABLE());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            Attribute attribute = element2.getAttribute("number-" + string + "s-repeated", this.getTABLE());
            if (attribute == null) continue;
            element2.removeAttribute(attribute);
            int n = listIterator.previousIndex();
            int n2 = Integer.parseInt(attribute.getValue());
            if (n2 > 60000) {
                n2 = 10;
            }
            for (int i = 0; i < n2 - 1; ++i) {
                Element element3 = (Element)element2.clone();
                list.add(n, element3);
            }
            listIterator = list.listIterator(n + n2);
        }
        return list;
    }

    public void detach() {
        this.getElement().detach();
    }

    private final String getName(boolean bl) {
        return bl ? "column" : "row";
    }

    private synchronized void addRow(Element element) {
        this.rows.add(new Row(this, element, this.rows.size()));
    }

    public final Column<D> getColumn(int n) {
        return this.cols.get(n);
    }

    public final int getRowCount() {
        return this.rows.size();
    }

    public final int getColumnCount() {
        return this.cols.size();
    }
}

