/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class SavePictureCalibrationToWorldAction
extends JosmAction {
    PicLayerAbstract m_owner = null;

    public SavePictureCalibrationToWorldAction(PicLayerAbstract owner) {
        super(I18n.tr((String)"Export World file Calibration...", (Object[])new Object[0]), null, I18n.tr((String)"Saves calibration data to a world file", (Object[])new Object[0]), null, false);
        this.m_owner = owner;
    }

    public void actionPerformed(ActionEvent arg0) {
        String wext;
        String picFilenameNoext;
        double[] values;
        block40: {
            String ext;
            block39: {
                String picFilename;
                values = new double[6];
                this.m_owner.saveWorldFile(values);
                picFilenameNoext = picFilename = this.m_owner.getPicLayerName();
                ext = null;
                int dotPos = picFilename.lastIndexOf(".");
                if (dotPos > 0) {
                    ext = picFilename.substring(dotPos + 1);
                    picFilenameNoext = picFilename.substring(0, dotPos);
                }
                if (ext != null) break block39;
                wext = String.valueOf(picFilenameNoext) + ".wld";
                break block40;
            }
            switch (ext) {
                case "jpg": {
                    wext = "jgw";
                    break;
                }
                case "jpeg": {
                    wext = "jpgw";
                    break;
                }
                case "png": {
                    wext = "pgw";
                    break;
                }
                case "bmp": {
                    wext = "bpw";
                    break;
                }
                case "tif": {
                    wext = "tfw";
                    break;
                }
                case "tiff": {
                    wext = "tifw";
                    break;
                }
                default: {
                    wext = "wld";
                }
            }
        }
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(true);
        fc.setSelectedFile(new File(String.valueOf(picFilenameNoext) + "." + wext));
        int result = fc.showSaveDialog((Component)MainApplication.getMainFrame());
        if (result == 0) {
            File file = fc.getSelectedFile();
            String path = file.getAbsolutePath();
            if (!path.contains(".")) {
                file = new File(String.valueOf(path) + "." + wext);
            }
            try {
                Throwable throwable = null;
                Object var14_16 = null;
                try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                    int i = 0;
                    while (i < 6) {
                        bw.write(Double.toString(values[i]));
                        if (i < 5) {
                            bw.newLine();
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logging.error((Throwable)e);
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Saving file failed: {0}", (Object[])new Object[]{e.getMessage()}), I18n.tr((String)"Problem occurred", (Object[])new Object[0]), 2);
            }
        }
    }
}

