/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.property;

import org.openstreetmap.josm.plugins.graphview.core.access.AccessParameters;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadPropertyType;
import org.openstreetmap.josm.plugins.graphview.core.util.ValueStringParser;

public class RoadMaxspeed
implements RoadPropertyType<Float> {
    private DataSource<?, ?, ?, ?> lastDataSource;

    private <N, W, R, M> void initializeIfNecessary(DataSource<N, W, R, M> dataSource) {
        if (dataSource != this.lastDataSource) {
            this.lastDataSource = dataSource;
        }
    }

    @Override
    public <N, W, R, M> Float evaluateN(N node, AccessParameters accessParameters, DataSource<N, W, R, M> dataSource) {
        assert (node != null && accessParameters != null && dataSource != null);
        this.initializeIfNecessary(dataSource);
        return this.evaluateTags(dataSource.getTagsN(node));
    }

    @Override
    public <N, W, R, M> Float evaluateW(W way, boolean forward, AccessParameters accessParameters, DataSource<N, W, R, M> dataSource) {
        assert (way != null && accessParameters != null && dataSource != null);
        this.initializeIfNecessary(dataSource);
        return this.evaluateTags(dataSource.getTagsW(way));
    }

    private Float evaluateTags(TagGroup tags) {
        Float maxspeed;
        String maxspeedString = tags.getValue("maxspeed");
        if (maxspeedString != null && (maxspeed = ValueStringParser.parseSpeed(maxspeedString)) != null) {
            return maxspeed;
        }
        return null;
    }

    @Override
    public boolean isUsable(Object propertyValue, AccessParameters accessParameters) {
        assert (propertyValue instanceof Float);
        return true;
    }
}

