/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.preferences;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionType;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PreferencesPanel
extends VerticallyScrollablePanel {
    private JRadioButton rbSetA;
    private JRadioButton rbSetB;
    private ButtonGroup bgIconSet;
    private JCheckBox cbShowViaListInBasicEditor;

    protected JPanel buildShowViaListInBasicEditorPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        HtmlPanel msg = new HtmlPanel();
        msg.setText("<html><body>" + I18n.tr((String)"The Basic Editor can optionally display the list of via-objects of a turn restriction. If enabled, one can edit them in the Basic editor too. If disabled, editing of via-objects is possible in the Advanced Editor only.", (Object[])new Object[0]) + "</body></html>");
        pnl.add((Component)msg, gc);
        ++gc.gridy;
        this.cbShowViaListInBasicEditor = new JCheckBox(I18n.tr((String)"Display and edit list of via-objects in the Basic Editor", (Object[])new Object[0]));
        pnl.add((Component)this.cbShowViaListInBasicEditor, gc);
        return pnl;
    }

    protected JPanel buildSetAPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        this.rbSetA = new JRadioButton(I18n.tr((String)"Road signs - Set A", (Object[])new Object[0]));
        pnl.add((Component)this.rbSetA, gc);
        JPanel icons = new JPanel(new FlowLayout(0));
        TurnRestrictionType[] turnRestrictionTypeArray = TurnRestrictionType.values();
        int n = turnRestrictionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TurnRestrictionType type = turnRestrictionTypeArray[n2];
            JLabel lbl = new JLabel();
            icons.add(lbl);
            lbl.setIcon(ImageProvider.get((String)"types/set-a", (String)type.getTagValue()));
            ++n2;
        }
        gc.gridy = 1;
        gc.insets = new Insets(0, 20, 0, 0);
        pnl.add((Component)icons, gc);
        return pnl;
    }

    protected JPanel buildSetBPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        this.rbSetB = new JRadioButton(I18n.tr((String)"Road signs - Set B", (Object[])new Object[0]));
        pnl.add((Component)this.rbSetB, gc);
        JPanel icons = new JPanel(new FlowLayout(0));
        TurnRestrictionType[] turnRestrictionTypeArray = TurnRestrictionType.values();
        int n = turnRestrictionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TurnRestrictionType type = turnRestrictionTypeArray[n2];
            JLabel lbl = new JLabel();
            icons.add(lbl);
            lbl.setIcon(ImageProvider.get((String)"types/set-b", (String)type.getTagValue()));
            ++n2;
        }
        gc.gridy = 1;
        gc.insets = new Insets(0, 20, 0, 0);
        pnl.add((Component)icons, gc);
        return pnl;
    }

    protected JPanel buildMessagePanel() {
        HtmlPanel pnl = new HtmlPanel();
        pnl.setText("<html><body>" + I18n.tr((String)"Please select the set of road sign icons to be used in the plugin.", (Object[])new Object[0]) + "</body></html>");
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        this.add(this.buildMessagePanel(), gc);
        ++gc.gridy;
        this.add(this.buildSetAPanel(), gc);
        ++gc.gridy;
        this.add(this.buildSetBPanel(), gc);
        ++gc.gridy;
        this.add(new JSeparator(), gc);
        ++gc.gridy;
        this.add(this.buildShowViaListInBasicEditorPanel(), gc);
        ++gc.gridy;
        this.add(new JSeparator(), gc);
        ++gc.gridy;
        ++gc.gridy;
        gc.fill = 1;
        gc.weighty = 1.0;
        this.add(new JPanel(), gc);
        this.bgIconSet = new ButtonGroup();
        this.bgIconSet.add(this.rbSetA);
        this.bgIconSet.add(this.rbSetB);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void initFromPreferences(IPreferences prefs) {
        String set = prefs.get("turnrestrictions.road-signs", "set-a");
        if (!set.equals("set-a") && !set.equals("set-b")) {
            System.out.println(I18n.tr((String)"Warning: the preference with key ''{0}'' has an unsupported value ''{1}''. Assuming the default value ''set-a''.", (Object[])new Object[]{"turnrestrictions.road-signs", set}));
            set = "set-a";
        }
        if (set.equals("set-a")) {
            this.rbSetA.setSelected(true);
        } else {
            this.rbSetB.setSelected(true);
        }
        boolean b = prefs.getBoolean("turnrestrictions.show-vias-in-basic-editor", false);
        this.cbShowViaListInBasicEditor.setSelected(b);
    }

    public void saveToPreferences(IPreferences prefs) {
        prefs.put("turnrestrictions.road-signs", this.rbSetA.isSelected() ? "set-a" : "set-b");
        prefs.putBoolean("turnrestrictions.show-vias-in-basic-editor", this.cbShowViaListInBasicEditor.isSelected());
    }

    public PreferencesPanel() {
        this.build();
    }
}

