/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import org.openstreetmap.josm.tools.I18n;

public enum TurnRestrictionType {
    NO_RIGHT_TURN("no_right_turn", I18n.tr((String)"No Right Turn", (Object[])new Object[0])),
    NO_LEFT_TURN("no_left_turn", I18n.tr((String)"No Left Turn", (Object[])new Object[0])),
    NO_U_TURN("no_u_turn", I18n.tr((String)"No U-Turn", (Object[])new Object[0])),
    NO_STRAIGHT_ON("no_straight_on", I18n.tr((String)"No Straight On", (Object[])new Object[0])),
    ONLY_RIGHT_TURN("only_right_turn", I18n.tr((String)"Only Right Turn", (Object[])new Object[0])),
    ONLY_LEFT_TURN("only_left_turn", I18n.tr((String)"Only Left Turn", (Object[])new Object[0])),
    ONLY_STRAIGHT_ON("only_straight_on", I18n.tr((String)"Only Straight On", (Object[])new Object[0]));

    private final String tagValue;
    private final String displayName;

    private TurnRestrictionType(String tagValue, String displayName) {
        this.tagValue = tagValue;
        this.displayName = displayName;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static TurnRestrictionType fromTagValue(String tagValue) {
        if (tagValue == null) {
            return null;
        }
        TurnRestrictionType[] turnRestrictionTypeArray = TurnRestrictionType.values();
        int n = turnRestrictionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TurnRestrictionType type = turnRestrictionTypeArray[n2];
            if (type.getTagValue().equals(tagValue)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isStandardTagValue(String tagValue) {
        return TurnRestrictionType.fromTagValue(tagValue) != null;
    }
}

