/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;

final class ImageComponent
extends JComponent {
    private static final long serialVersionUID = -5207198660736375133L;
    private Image image = null;

    ImageComponent() {
    }

    @Override
    public void paint(Graphics g) {
        if (this.image == null || this.image.getWidth(null) <= 0 || this.image.getHeight(null) <= 0) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        } else {
            int resizedHeight;
            int resizedWidth;
            int imageHeight;
            int maxWidth = this.getSize().width;
            int maxHeight = this.getSize().height;
            int imageWidth = this.image.getWidth(null);
            double aspect = 1.0 * (double)imageWidth / (double)(imageHeight = this.image.getHeight(null));
            int widthIfHeightIsMax = (int)(aspect * (double)maxHeight);
            if (widthIfHeightIsMax > maxWidth) {
                resizedWidth = maxWidth;
                resizedHeight = (int)((double)resizedWidth / aspect);
            } else {
                resizedWidth = widthIfHeightIsMax;
                resizedHeight = maxHeight;
            }
            g.drawImage(this.image, (maxWidth - resizedWidth) / 2, (maxHeight - resizedHeight) / 2, resizedWidth, resizedHeight, Color.black, null);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }
}

