/*
 * Decompiled with CFR 0.152.
 */
package poly;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.OsmImporter;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import poly.PolyType;

public class PolyImporter
extends OsmImporter {
    public PolyImporter() {
        super(PolyType.FILE_FILTER);
    }

    protected DataSet parseDataSet(String source) throws IOException, IllegalDataException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CachedFile cf = new CachedFile(source);){
            return this.parseDataSet(cf.getInputStream(), NullProgressMonitor.INSTANCE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull((Object)in, (String)"in");
        try {
            DataSet dataSet;
            block16: {
                Throwable throwable = null;
                Object var4_6 = null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                try {
                    progressMonitor.beginTask(I18n.tr((String)"Reading polygon filter file...", (Object[])new Object[0]), 3);
                    progressMonitor.indeterminateSubTask(I18n.tr((String)"Reading polygon filter file...", (Object[])new Object[0]));
                    List<Area> areas = PolyImporter.loadPolygon(reader);
                    progressMonitor.worked(1);
                    progressMonitor.indeterminateSubTask(I18n.tr((String)"Preparing data set...", (Object[])new Object[0]));
                    DataSet ds = PolyImporter.constructDataSet(areas);
                    progressMonitor.worked(1);
                    dataSet = ds;
                    if (reader == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalDataException(I18n.tr((String)"Error reading poly file: {0}", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                }
                reader.close();
            }
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static List<Area> loadPolygon(BufferedReader reader) throws IllegalDataException, IOException {
        String line;
        String name = reader.readLine();
        if (name == null || name.trim().length() == 0) {
            throw new IllegalDataException(I18n.tr((String)"The file must begin with a polygon name", (Object[])new Object[0]));
        }
        ArrayList<Area> areas = new ArrayList<Area>();
        Area area = null;
        boolean parsingSection = false;
        int fixedCoords = 0;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) {
                if (parsingSection) {
                    throw new IllegalDataException(I18n.tr((String)"Empty line in coordinate section", (Object[])new Object[0]));
                }
                area = null;
                parsingSection = false;
                name = null;
                continue;
            }
            if ("END".equals(line)) {
                if (!parsingSection) {
                    area = null;
                    continue;
                }
                if (area.getNodeCount() < 2) {
                    throw new IllegalDataException(I18n.tr((String)"There are less than 2 points in an area", (Object[])new Object[0]));
                }
                areas.add(area);
                area.setPolygonName(name);
                parsingSection = false;
                continue;
            }
            if (name == null) {
                name = line;
                continue;
            }
            if (line.length() <= 0) continue;
            if (!parsingSection) {
                if (line.indexOf(32) >= 0) {
                    boolean coordInsteadOfName = false;
                    try {
                        LatLon ll = PolyImporter.parseCoordinate(line);
                        if (ll.isValid()) {
                            coordInsteadOfName = true;
                        }
                    }
                    catch (IllegalDataException e) {
                        coordInsteadOfName = false;
                    }
                    if (coordInsteadOfName) {
                        throw new IllegalDataException(I18n.tr((String)"Found coordinates ''{0}'' instead of name", (Object[])new Object[]{line}));
                    }
                }
                area = new Area(line);
                parsingSection = true;
                continue;
            }
            LatLon coord = PolyImporter.parseCoordinate(line);
            if (!coord.isValid()) {
                double lat = coord.lat();
                double lon = coord.lon();
                if (lon < -180.0 && lon > -185.0) {
                    lon = -180.0;
                }
                if (lon > 180.0 && lon < 185.0) {
                    lon = 180.0;
                }
                if (lat < -90.0 && lat > -95.0) {
                    lat = -90.0;
                }
                if (lat > 90.0 && lat < 95.0) {
                    lat = 90.0;
                }
                coord = new LatLon(lat, lon);
                ++fixedCoords;
                if (!coord.isValid()) {
                    throw new IllegalDataException(I18n.tr((String)"Invalid coordinates were found: {0}, {1}", (Object[])new Object[]{coord.lat(), coord.lon()}));
                }
            }
            area.addNode(PolyImporter.parseCoordinate(line));
        }
        if (fixedCoords > 0) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"{0} points were outside world bounds and were moved", (Object[])new Object[]{fixedCoords}), "Import poly", 2);
        }
        return areas;
    }

    private static LatLon parseCoordinate(String line) throws IllegalDataException {
        String[] tokens = line.split("\\s+");
        double[] coords = new double[2];
        int tokenCount = 0;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.length() > 0) {
                if (tokenCount > 2) break;
                try {
                    coords[tokenCount++] = Double.parseDouble(token);
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(I18n.tr((String)"Unable to parse {0} as a number", (Object[])new Object[]{token}));
                }
            }
            ++n2;
        }
        if (tokenCount != 2) {
            throw new IllegalDataException(I18n.tr((String)"A polygon coordinate line must contain exactly 2 numbers", (Object[])new Object[0]));
        }
        return new LatLon(coords[1], coords[0]);
    }

    private static DataSet constructDataSet(List<Area> areas) {
        DataSet ds = new DataSet();
        ds.setUploadPolicy(UploadPolicy.DISCOURAGED);
        ArrayList<Area> curretSet = new ArrayList<Area>();
        for (Area area : areas) {
            if (!curretSet.isEmpty() && !area.polygonName.equals(((Area)curretSet.get(0)).polygonName)) {
                PolyImporter.constructPrimitive(ds, curretSet);
                curretSet.clear();
            }
            curretSet.add(area);
        }
        if (!curretSet.isEmpty()) {
            PolyImporter.constructPrimitive(ds, curretSet);
        }
        return ds;
    }

    private static void constructPrimitive(DataSet ds, List<Area> areas) {
        boolean isMultipolygon = areas.size() > 1;
        for (Area area : areas) {
            area.constructWay(ds, isMultipolygon);
        }
        if (isMultipolygon) {
            Relation mp = new Relation();
            mp.put("type", "multipolygon");
            Area outer = areas.get(0);
            if (outer.polygonName != null) {
                mp.put("name", outer.polygonName);
            }
            for (Area area : areas) {
                mp.addMember(new RelationMember(area.isOuter() ? "outer" : "inner", (OsmPrimitive)area.getWay()));
            }
            ds.addPrimitive((OsmPrimitive)mp);
        }
    }

    private static class Area {
        private String name;
        private String polygonName;
        private List<LatLon> nodes;
        private boolean outer;
        private Way way;

        Area(String name) {
            this.name = name;
            boolean bl = this.outer = name.charAt(0) != '!';
            if (!this.outer) {
                this.name = this.name.substring(1);
            }
            this.nodes = new ArrayList<LatLon>();
            this.way = null;
            this.polygonName = "";
        }

        public void setPolygonName(String polygonName) {
            if (polygonName != null) {
                this.polygonName = polygonName;
            }
        }

        public void addNode(LatLon node) {
            if (this.nodes.isEmpty() || !this.nodes.get(this.nodes.size() - 1).equals((Object)node) && !this.nodes.get(0).equals((Object)node)) {
                this.nodes.add(node);
            }
        }

        public boolean isOuter() {
            return this.outer;
        }

        public int getNodeCount() {
            return this.nodes.size();
        }

        public Way getWay() {
            return this.way;
        }

        public void constructWay(DataSet ds, boolean isMultipolygon) {
            this.way = new Way();
            for (LatLon coord : this.nodes) {
                Node node = new Node(coord);
                ds.addPrimitive((OsmPrimitive)node);
                this.way.addNode(node);
            }
            this.way.addNode(this.way.getNode(0));
            if (isMultipolygon && this.name != null) {
                this.way.put("name", this.name);
            } else if (this.polygonName != null) {
                this.way.put("name", this.polygonName);
            }
            ds.addPrimitive((OsmPrimitive)this.way);
        }
    }
}

