/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geojson;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.geojson.GeoJsonLayer;
import org.openstreetmap.josm.plugins.geojson.GeoJsonReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class GeoJsonFileImporter
extends FileImporter {
    private static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions((String)"geojson,json", (String)"geojson", (String)(I18n.tr((String)"GeoJSON file", (Object[])new Object[0]) + " (*.geojson, *.geojson.gz, *.geojson.bz2, *.geojson.xz, *.geojson.zip, *.json)"), (ExtensionFileFilter.AddArchiveExtension)ExtensionFileFilter.AddArchiveExtension.NONE, Arrays.asList("gz", "bz", "bz2", "xz", "zip"));

    public GeoJsonFileImporter() {
        super(FILE_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(File file, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr((String)"Loading json file\u2026", (Object[])new Object[0]));
        progressMonitor.setTicksCount(2);
        Logging.info((String)("Parsing GeoJSON: " + file.getAbsolutePath()));
        try (InputStream fileInputStream = Compression.getUncompressedFileInputStream((File)file);){
            GeoJsonReader geoJsonReader = new GeoJsonReader();
            DataSet data = geoJsonReader.doParseDataSet(fileInputStream, progressMonitor);
            progressMonitor.worked(1);
            Bounds bounds = null;
            for (OsmPrimitive osmPrimitive : data.allPrimitives()) {
                bounds = this.mergeBounds(bounds, osmPrimitive);
            }
            GeoJsonLayer layer = new GeoJsonLayer(I18n.tr((String)"Data Layer from GeoJSON: ", (Object[])new Object[0]) + file.getName(), data, bounds);
            MainApplication.getLayerManager().addLayer((Layer)layer);
        }
        catch (Exception e) {
            Logging.error((String)"Error while reading json file!");
            Logging.error((Throwable)e);
            GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(null, I18n.tr((String)"Error loading geojson file {0}", (Object[])new Object[]{file.getAbsolutePath()}), I18n.tr((String)"Error", (Object[])new Object[0]), 2));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public DataSet parseDataSet(String source) throws IOException, IllegalDataException {
        try (CachedFile cf = new CachedFile(source);){
            InputStream fileInputStream = Compression.getUncompressedFileInputStream((File)cf.getFile());
            DataSet dataSet = GeoJsonReader.parseDataSet(fileInputStream, NullProgressMonitor.INSTANCE);
            return dataSet;
        }
    }

    private Bounds mergeBounds(Bounds bounds, OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            return this.mergeBounds(bounds, ((Node)osmPrimitive).getCoor());
        }
        return bounds;
    }

    private Bounds mergeBounds(Bounds bounds, LatLon coords) {
        if (bounds == null) {
            return new Bounds(coords);
        }
        bounds.extend(coords);
        return bounds;
    }
}

