/*
 * Decompiled with CFR 0.152.
 */
package nanolog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import nanolog.NanoLogEntry;
import nanolog.NanoLogLayer;
import nanolog.NanoLogPanel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;

public class NanoLogPlugin
extends Plugin {
    public NanoLogPlugin(PluginInformation info) {
        super(info);
        MainApplication.getMenu().fileMenu.insert((Action)((Object)new OpenNanoLogLayerAction()), 4);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            NanoLogPanel panel = new NanoLogPanel();
            newFrame.addToggleDialog((ToggleDialog)panel);
            MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)panel);
        }
    }

    private static class OpenNanoLogLayerAction
    extends JosmAction {
        OpenNanoLogLayerAction() {
            super(I18n.tr((String)"Open NanoLog file...", (Object[])new Object[0]), "nanolog.png", I18n.tr((String)"Open NanoLog file...", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            if (fc.showOpenDialog((Component)MainApplication.getMainFrame()) == 0) {
                try {
                    List<NanoLogEntry> entries = NanoLogLayer.readNanoLog(fc.getSelectedFile());
                    if (!entries.isEmpty()) {
                        NanoLogLayer layer = new NanoLogLayer(entries);
                        MainApplication.getLayerManager().addLayer((Layer)layer);
                        layer.setupListeners();
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), String.valueOf(I18n.tr((String)"Could not read NanoLog file:", (Object[])new Object[0])) + "\n" + ex.getMessage());
                }
            }
        }
    }
}

