/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.mac;

import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.mac.SecurityLibrary;
import org.netbeans.spi.keyring.KeyringProvider;

public class MacProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(MacProvider.class.getName());

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public char[] read(String key) {
        Pointer[] data;
        int[] dataLength;
        block3: {
            try {
                byte[] serviceName = key.getBytes("UTF-8");
                byte[] accountName = "JOSM".getBytes("UTF-8");
                dataLength = new int[1];
                data = new Pointer[1];
                MacProvider.error("find", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountName.length, accountName, dataLength, data, null));
                if (data[0] != null) break block3;
                return null;
            }
            catch (UnsupportedEncodingException x) {
                LOG.log(Level.WARNING, null, x);
                return null;
            }
        }
        byte[] value = data[0].getByteArray(0L, dataLength[0]);
        return new String(value, "UTF-8").toCharArray();
    }

    @Override
    public void save(String key, char[] password, String description) {
        try {
            byte[] serviceName = key.getBytes("UTF-8");
            byte[] accountName = "JOSM".getBytes("UTF-8");
            byte[] data = new String(password).getBytes("UTF-8");
            Pointer[] itemRef = new Pointer[1];
            MacProvider.error("find (for save)", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountName.length, accountName, null, null, itemRef));
            if (itemRef[0] != null) {
                MacProvider.error("save (update)", SecurityLibrary.LIBRARY.SecKeychainItemModifyContent(itemRef[0], null, data.length, data));
                SecurityLibrary.LIBRARY.CFRelease(itemRef[0]);
            } else {
                MacProvider.error("save (new)", SecurityLibrary.LIBRARY.SecKeychainAddGenericPassword(null, serviceName.length, serviceName, accountName.length, accountName, data.length, data, null));
            }
        }
        catch (UnsupportedEncodingException x) {
            LOG.log(Level.WARNING, null, x);
        }
    }

    @Override
    public void delete(String key) {
        try {
            byte[] serviceName = key.getBytes("UTF-8");
            byte[] accountName = "JOSM".getBytes("UTF-8");
            Pointer[] itemRef = new Pointer[1];
            MacProvider.error("find (for delete)", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountName.length, accountName, null, null, itemRef));
            if (itemRef[0] != null) {
                MacProvider.error("delete", SecurityLibrary.LIBRARY.SecKeychainItemDelete(itemRef[0]));
                SecurityLibrary.LIBRARY.CFRelease(itemRef[0]);
            }
        }
        catch (UnsupportedEncodingException x) {
            LOG.log(Level.WARNING, null, x);
        }
    }

    private static void error(String msg, int code) {
        if (code != 0 && code != -25300) {
            String str;
            Pointer translated = SecurityLibrary.LIBRARY.SecCopyErrorMessageString(code, null);
            if (translated == null) {
                str = String.valueOf(code);
            } else {
                char[] buf = new char[(int)SecurityLibrary.LIBRARY.CFStringGetLength(translated)];
                int i = 0;
                while (i < buf.length) {
                    buf[i] = SecurityLibrary.LIBRARY.CFStringGetCharacterAtIndex(translated, i);
                    ++i;
                }
                SecurityLibrary.LIBRARY.CFRelease(translated);
                str = String.valueOf(new String(buf)) + " (" + code + ")";
            }
            LOG.log(Level.WARNING, "{0}: {1}", new Object[]{msg, str});
        }
    }
}

