/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.LeadsTo;

public class TRDFS {
    private final ArrayList<LeadsTo> cycleEdges;
    private final ChannelDiGraph digraph;

    public TRDFS(ArrayList<Channel> adnodes, ChannelDiGraph digraph) {
        this.digraph = digraph;
        this.cycleEdges = new ArrayList();
    }

    public void trdfs(Channel startNode) {
        startNode.setVisited(0);
        startNode.addReachableNode(startNode);
        startNode.appendChannelToPath(startNode, startNode);
        int i = 0;
        while (i < startNode.getLeadsTo().size()) {
            Channel succNode = startNode.getLeadsTo().get(i).getToChannel();
            if (succNode.isSubgraph()) {
                if (succNode.getVisited() == -1) {
                    this.digraph.setForwardEdge(startNode, succNode);
                    this.trdfs(succNode);
                } else if (succNode.getVisited() == 0) {
                    this.cycleEdges.add(this.digraph.getLeadsTo(startNode, succNode));
                }
                int j = 0;
                while (j < succNode.getReachableNodes().size()) {
                    startNode.addReachableNode(succNode.getReachableNodeAt(j));
                    succNode.appendChannelToPath(succNode.getReachableNodeAt(j), succNode.getReachableNodeAt(j));
                    succNode.appendChannelToPath(succNode.getReachableNodeAt(j), succNode);
                    startNode.appendPath(succNode.getReachableNodeAt(j), succNode.getPathsAt(succNode.getReachableNodeAt(j)));
                    ++j;
                }
            }
            ++i;
        }
        startNode.setVisited(1);
    }

    public void ereaseCycleEdges() {
        this.cycleEdges.clear();
    }

    public int getCycleedgesSize() {
        return this.cycleEdges.size();
    }

    public LeadsTo getCycleEdgeAt(int i) {
        return this.cycleEdges.get(i);
    }

    public ArrayList<LeadsTo> getCycleEdges() {
        return this.cycleEdges;
    }
}

