/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.Combination;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JCheck;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JPrepare;
import org.openstreetmap.josm.tools.I18n;

public class JMinimality {
    private boolean CheckMinimal = true;
    private final ArrayList<Channel> E;
    private final int[][] Grid;
    private final ArrayList<Channel> OrEn;
    private final ArrayList<Channel> OrEx;
    private final int n;
    private final List<List<Object>> L = new ArrayList<List<Object>>();
    private final HashSet<Channel> subgraph = new HashSet();
    private ProgressMonitor pm;
    private final boolean pmenabled;
    private final ArrayList<HashSet<Channel>> junctions = new ArrayList();
    private final boolean searchFirstJunction;
    private final ArrayList<Channel> subJunction = new ArrayList();
    private final JPrepare jprepare;
    private boolean Check = false;
    private Iterator<int[]> it;

    public JMinimality(int[][] Grid, int n, ArrayList<Channel> E, ArrayList<Channel> entries, ArrayList<Channel> exits, ChannelDiGraph channeldigraph, boolean junctionsearch) {
        this.E = E;
        this.n = n;
        this.Grid = Grid;
        this.OrEn = entries;
        this.OrEx = exits;
        this.pmenabled = false;
        this.searchFirstJunction = junctionsearch;
        this.jprepare = new JPrepare(channeldigraph);
    }

    public JMinimality(int[][] Grid, int n, ArrayList<Channel> E, ArrayList<Channel> entries, ArrayList<Channel> exits, ChannelDiGraph channeldigraph, ProgressMonitor pm, boolean junctionsearch) {
        this.E = E;
        this.n = n;
        this.Grid = Grid;
        this.OrEn = entries;
        this.OrEx = exits;
        this.pm = pm;
        this.pmenabled = true;
        this.searchFirstJunction = junctionsearch;
        this.jprepare = new JPrepare(channeldigraph);
    }

    public void GenerateSubcolumns() {
        if (this.pmenabled) {
            this.pm.setCustomText(I18n.tr((String)"generate all combinations from entrie/exit candidates", (Object[])new Object[0]));
        }
        Combination c = new Combination(this.Grid.length, this.n);
        long ans = c.Choose();
        int i = 0;
        while (i < this.Grid.length) {
            int h = 0;
            do {
                int missing = 0;
                ArrayList<Object> C = new ArrayList<Object>(3);
                int[][] v = new int[this.n][2];
                C.add(i);
                C.add(h);
                int t = 0;
                while (t < c.data.length) {
                    if (this.Grid[(int)c.data[t]][i] == 0) {
                        ++missing;
                        v[t][1] = 0;
                    } else {
                        v[t][1] = 1;
                    }
                    v[t][0] = (int)c.data[t];
                    ++t;
                }
                if (missing <= 1) {
                    C.add(v);
                    this.L.add(C);
                }
                if ((long)(++h) >= ans) continue;
                c = c.Successor();
            } while ((long)h < ans);
            c = new Combination(this.Grid.length, this.n);
            ++i;
        }
        Collections.sort(this.L, new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                return (Integer)o1.get(1) - (Integer)o2.get(1);
            }
        });
    }

    public boolean IterateThroughKn() {
        if (this.L.size() == 0) {
            return true;
        }
        if (this.pmenabled) {
            this.pm.setTicksCount(this.L.size());
            this.pm.setCustomText("Iterates through all K_{n-1} subgrids of the Grid and tests them");
        }
        ListIterator<List<Object>> l = this.L.listIterator();
        ArrayList<int[]> CandidateK = new ArrayList<int[]>(this.n * this.n);
        long lindex = 0L;
        int h = 0;
        int m = 0;
        int progressmonitorcounter = 1;
        boolean mchanged = false;
        boolean hchanged = false;
        List C = (List)l.next();
        do {
            if (mchanged) {
                C = (List)l.next();
                ++lindex;
                if (hchanged) {
                    m = 1;
                    hchanged = false;
                }
            }
            if ((Integer)C.get(1) == h && l.hasNext()) {
                ++m;
                mchanged = true;
            } else {
                if (!l.hasNext()) {
                    ++m;
                    ++lindex;
                }
                Combination c = new Combination(m, this.n);
                long ans = c.Choose();
                int missing = 0;
                boolean smallerjunction = false;
                int k = 0;
                while ((long)k < ans) {
                    int y = 0;
                    while (y < this.n) {
                        missing = 0;
                        int x = 0;
                        while (x < c.data.length) {
                            int x_i = (Integer)this.L.get((int)(lindex - (long)m + c.data[x])).get(0);
                            int[][] v = (int[][])this.L.get((int)(lindex - (long)m + c.data[x])).get(2);
                            int y_j = v[y][0];
                            if (v[y][1] == 0) {
                                ++missing;
                            } else {
                                CandidateK.add(new int[]{y_j, x_i});
                            }
                            if (!(smallerjunction || this.OrEn.contains(this.E.get(v[y][0])) || this.OrEx.contains(this.E.get(x_i)))) {
                                smallerjunction = true;
                            }
                            ++x;
                        }
                        if (missing > 1) break;
                        ++y;
                    }
                    if (missing <= 1 && smallerjunction) {
                        boolean bl = this.CheckMinimal = !this.CheckSmallJunction(CandidateK);
                        if (!this.CheckMinimal) break;
                    }
                    CandidateK.clear();
                    if ((long)(k + 1) < ans) {
                        c = c.Successor();
                    }
                    ++k;
                }
                m = 1;
                ++h;
                mchanged = false;
                hchanged = true;
            }
            if (!this.pmenabled) continue;
            this.pm.setTicks(++progressmonitorcounter);
        } while (l.hasNext() && this.CheckMinimal);
        return this.CheckMinimal;
    }

    public boolean CheckSmallJunction(ArrayList<int[]> CandidateK) {
        this.Check = false;
        this.subgraph.clear();
        for (int[] point : CandidateK) {
            int j = 0;
            while (j < this.E.get(point[0]).getReachableNodes().size()) {
                if (this.E.get(point[0]).getReachableNodeAt(j).equals(this.E.get(point[1]))) {
                    this.subgraph.addAll(this.E.get(point[0]).getPathsAt(this.E.get(point[0]).getReachableNodeAt(j)));
                    this.subgraph.add(this.E.get(point[0]));
                }
                ++j;
            }
        }
        this.jprepare.jPrepare(new ArrayList<Channel>(this.subgraph));
        JCheck jCheck = new JCheck();
        this.Check = jCheck.jCheck(this.jprepare.getEntries(), this.jprepare.getExits(), this.n);
        this.jprepare.resetSubgraph();
        if (this.Check) {
            this.subJunction.clear();
            this.subJunction.addAll(this.subgraph);
            if (!this.searchFirstJunction) {
                boolean isin = false;
                int i = 0;
                while (i < this.junctions.size()) {
                    if (this.junctions.get(i).size() == this.subgraph.size()) {
                        Iterator<Channel> it = this.subgraph.iterator();
                        isin = true;
                        while (it.hasNext()) {
                            if (this.junctions.get(i).contains(it.next())) continue;
                            isin = false;
                        }
                    }
                    ++i;
                }
                if (!isin) {
                    this.junctions.add(new HashSet<Channel>(this.subgraph));
                }
                this.Check = false;
            }
        }
        return this.Check;
    }

    public ArrayList<Channel> getSubJunctionCandidate() {
        return new ArrayList<Channel>(this.subgraph);
    }

    public ArrayList<HashSet<Channel>> getJunctionCandidates() {
        return this.junctions;
    }
}

