/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.datastructure;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMEntity;

public class OSMRelation
extends OSMEntity {
    private ArrayList<Member> members = new ArrayList();

    public void setMembers(ArrayList<Member> members) {
        this.members = members;
    }

    public ArrayList<Member> getMembers() {
        return this.members;
    }

    public OSMEntity getMember(String role) {
        int i = 0;
        while (i < this.members.size()) {
            if (this.members.get(i).getRole().equals(role)) {
                return this.members.get(i).getMember();
            }
            ++i;
        }
        return null;
    }

    public void addMember(OSMEntity member, String role) {
        this.members.add(new Member(member, role));
    }

    public String getRelationType(String key) {
        return this.getValue(key);
    }

    public String toString() {
        String s = "Relation-ID: " + this.getId() + " Relation-Type: " + this.getRelationType("type") + "\n";
        for (Member member : this.members) {
            s = String.valueOf(s) + member.toString();
        }
        return s;
    }

    static class Member {
        private OSMEntity member;
        private String role;

        Member(OSMEntity member, String role) {
            this.member = member;
            this.setRole(role);
        }

        public Class<? extends OSMEntity> getType() {
            return this.member.getClass();
        }

        public void setMember(OSMEntity member) {
            this.member = member;
        }

        public OSMEntity getMember() {
            return this.member;
        }

        public Long getId() {
            return this.member.getId();
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getRole() {
            return this.role;
        }

        public String toString() {
            return "Member: " + this.getRole() + ", ref:" + this.getId() + ", type:" + this.getType().getName();
        }
    }
}

