/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.datastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Graph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMNode;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMRelation;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMWay;

public class OSMGraph
extends Graph {
    private final HashMap<Long, OSMWay> ways = new HashMap();
    private HashMap<Long, OSMRelation> relations = new HashMap();
    private final HashMap<Long, OSMNode> nodes = new HashMap();

    public void addNode(OSMNode node) {
        this.nodes.put(node.getId(), node);
    }

    public OSMNode getNode(long id) {
        return this.nodes.get(id);
    }

    public void removeWay(OSMWay way) {
        while (this.ways.values().remove(way)) {
        }
    }

    public OSMNode[] getNodes() {
        OSMNode[] nodearray = new OSMNode[this.nodes.size()];
        return this.nodes.values().toArray(nodearray);
    }

    public void addWay(OSMWay way) {
        this.ways.put(way.getId(), way);
    }

    public OSMWay getWay(long id) {
        return this.ways.get(id);
    }

    public OSMRelation getRelation(int id) {
        return this.relations.get(id);
    }

    public HashMap<Long, OSMRelation> getRelationsAshashmap() {
        return this.relations;
    }

    public void setRelations(HashMap<Long, OSMRelation> relations) {
        this.relations = relations;
    }

    public OSMWay[] getWays() {
        OSMWay[] wayarray = new OSMWay[this.ways.size()];
        return this.ways.values().toArray(wayarray);
    }

    public void addRelation(OSMRelation relation) {
        this.relations.put(relation.getId(), relation);
    }

    public OSMRelation[] getRelations() {
        OSMRelation[] relationarray = new OSMRelation[this.relations.size()];
        return this.relations.values().toArray(relationarray);
    }

    public Collection<OSMRelation> getRelationsCollection() {
        return this.relations.values();
    }

    public boolean hasNode(Long id) {
        return this.nodes.containsKey(id);
    }

    public ArrayList<Long> getIDsfromWay(int id) {
        OSMWay w = this.ways.get(id);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(w.getToNode().getId());
        ids.add(w.getFromNode().getId());
        return ids;
    }

    public void addNode(Node node) {
        OSMNode OSMnode = new OSMNode();
        OSMnode.setId(node.getId());
        OSMnode.setLatitude(node.getBBox().getTopLeft().lat());
        OSMnode.setLongitude(node.getBBox().getTopLeft().lon());
        OSMnode.setHashmap(new HashMap<String, String>((Map<String, String>)node.getKeys()));
        this.nodes.put(OSMnode.getId(), OSMnode);
    }

    public void addWay(Way way) {
        OSMWay osmway = new OSMWay();
        osmway.setId(way.getId());
        Iterator it = way.getNodes().iterator();
        while (it.hasNext()) {
            osmway.addNode(this.getNode(((Node)it.next()).getId()));
        }
        osmway.setHashmap(new HashMap<String, String>((Map<String, String>)way.getKeys()));
        this.ways.put(osmway.getId(), osmway);
    }

    public void addRelation(Relation relation) {
        OSMRelation osmrelation = new OSMRelation();
        osmrelation.setId(relation.getId());
        osmrelation.setHashmap(new HashMap<String, String>((Map<String, String>)relation.getKeys()));
        int i = 0;
        while (i < relation.getMembers().size()) {
            RelationMember rmember = relation.getMember(i);
            if (rmember.getMember() instanceof Node) {
                osmrelation.addMember(this.getNode(rmember.getMember().getId()), rmember.getRole());
            } else if (rmember.getMember() instanceof Way) {
                osmrelation.addMember(this.getWay(rmember.getMember().getId()), rmember.getRole());
            }
            ++i;
        }
        this.relations.put(osmrelation.getId(), osmrelation);
    }
}

