/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary;

import com.google.protobuf.InvalidProtocolBufferException;
import crosby.binary.Osmformat;
import crosby.binary.file.BlockReaderAdapter;
import crosby.binary.file.FileBlock;
import crosby.binary.file.FileBlockPosition;
import java.util.Date;
import java.util.List;

public abstract class BinaryParser
implements BlockReaderAdapter {
    protected int granularity;
    private long lat_offset;
    private long lon_offset;
    protected int date_granularity;
    private String[] strings;
    public static final Date NODATE = new Date(-1L);

    protected Date getDate(Osmformat.Info info) {
        if (info.hasTimestamp()) {
            return new Date((long)this.date_granularity * info.getTimestamp());
        }
        return NODATE;
    }

    protected String getStringById(int id) {
        return this.strings[id];
    }

    @Override
    public void handleBlock(FileBlock message) {
        try {
            if (message.getType().equals("OSMHeader")) {
                Osmformat.HeaderBlock headerblock = Osmformat.HeaderBlock.parseFrom(message.getData());
                this.parse(headerblock);
            } else if (message.getType().equals("OSMData")) {
                Osmformat.PrimitiveBlock primblock = Osmformat.PrimitiveBlock.parseFrom(message.getData());
                this.parse(primblock);
            }
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            throw new Error("ParseError");
        }
    }

    @Override
    public boolean skipBlock(FileBlockPosition block) {
        if (block.getType().equals("OSMData")) {
            return false;
        }
        if (block.getType().equals("OSMHeader")) {
            return false;
        }
        System.out.println("Skipped block of type: " + block.getType());
        return true;
    }

    public double parseLat(long degree) {
        return (double)((long)this.granularity * degree + this.lat_offset) * 1.0E-9;
    }

    public double parseLon(long degree) {
        return (double)((long)this.granularity * degree + this.lon_offset) * 1.0E-9;
    }

    public void parse(Osmformat.PrimitiveBlock block) {
        Osmformat.StringTable stablemessage = block.getStringtable();
        this.strings = new String[stablemessage.getSCount()];
        int i = 0;
        while (i < this.strings.length) {
            this.strings[i] = stablemessage.getS(i).toStringUtf8();
            ++i;
        }
        this.granularity = block.getGranularity();
        this.lat_offset = block.getLatOffset();
        this.lon_offset = block.getLonOffset();
        this.date_granularity = block.getDateGranularity();
        for (Osmformat.PrimitiveGroup groupmessage : block.getPrimitivegroupList()) {
            this.parseNodes(groupmessage.getNodesList());
            this.parseWays(groupmessage.getWaysList());
            this.parseRelations(groupmessage.getRelationsList());
            if (!groupmessage.hasDense()) continue;
            this.parseDense(groupmessage.getDense());
        }
    }

    protected abstract void parseRelations(List<Osmformat.Relation> var1);

    protected abstract void parseDense(Osmformat.DenseNodes var1);

    protected abstract void parseNodes(List<Osmformat.Node> var1);

    protected abstract void parseWays(List<Osmformat.Way> var1);

    protected abstract void parse(Osmformat.HeaderBlock var1);
}

