/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.commands;

import java.util.Collection;
import java.util.Vector;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.public_transport.actions.StopImporterAction;
import org.openstreetmap.josm.plugins.public_transport.models.WaypointTableModel;
import org.openstreetmap.josm.tools.I18n;

public class WaypointsDisableCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Vector<Node> nodesForUndo = null;
    private WaypointTableModel waypointTM = null;

    public WaypointsDisableCommand(StopImporterAction controller) {
        super(MainApplication.getLayerManager().getEditDataSet());
        int i;
        this.waypointTM = controller.getWaypointTableModel();
        this.workingLines = new Vector();
        this.nodesForUndo = new Vector();
        int[] selectedLines = controller.getDialog().getWaypointsTable().getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            i = 0;
            while (i < selectedLines.length) {
                consideredLines.add(selectedLines[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.waypointTM.getRowCount()) {
                consideredLines.add(i);
                ++i;
            }
        }
        i = 0;
        while (i < consideredLines.size()) {
            if (this.waypointTM.nodes.elementAt((Integer)consideredLines.elementAt(i)) != null) {
                this.workingLines.add((Integer)consideredLines.elementAt(i));
            }
            ++i;
        }
    }

    public boolean executeCommand() {
        this.nodesForUndo.clear();
        int i = 0;
        while (i < this.workingLines.size()) {
            int j = this.workingLines.elementAt(i);
            Node node = this.waypointTM.nodes.elementAt(j);
            this.nodesForUndo.add(node);
            if (node != null) {
                this.waypointTM.nodes.set(j, null);
                MainApplication.getLayerManager().getEditDataSet().removePrimitive((PrimitiveId)node);
                node.setDeleted(true);
            }
            ++i;
        }
        return true;
    }

    public void undoCommand() {
        int i = 0;
        while (i < this.workingLines.size()) {
            int j = this.workingLines.elementAt(i);
            Node node = this.nodesForUndo.elementAt(i);
            this.waypointTM.nodes.set(j, node);
            if (node != null) {
                node.setDeleted(false);
                MainApplication.getLayerManager().getEditDataSet().addPrimitive((OsmPrimitive)node);
            }
            ++i;
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Disable waypoints", (Object[])new Object[0]);
    }
}

