/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import geochat.JsonQueryCallback;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public final class JsonQueryUtil
implements Runnable {
    private String query;
    private JsonQueryCallback callback;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject query(String query) throws IOException {
        try {
            String serverURL = Config.getPref().get("geochat.server", "https://zverik.dev.openstreetmap.org/osmochat.php?action=");
            URL url = new URL(serverURL + query);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new IOException("HTTP Response code " + connection.getResponseCode() + " (" + connection.getResponseMessage() + ")");
            }
            InputStream inp = connection.getInputStream();
            if (inp == null) {
                throw new IOException("Empty response");
            }
            try {
                JsonObject jsonObject = Json.createReader((InputStream)inp).readObject();
                return jsonObject;
            }
            catch (JsonException e) {
                throw new IOException("Failed to parse JSON: " + e.getMessage());
            }
            finally {
                connection.disconnect();
            }
        }
        catch (MalformedURLException ex) {
            throw new IOException("Malformed URL: " + ex.getMessage());
        }
    }

    private JsonQueryUtil() {
    }

    private JsonQueryUtil(String query, JsonQueryCallback callback) {
        this.query = query;
        this.callback = callback;
    }

    public static void queryAsync(String query, JsonQueryCallback callback) {
        MainApplication.worker.submit(new JsonQueryUtil(query, callback));
    }

    private void doRealRun() {
        JsonObject obj;
        try {
            obj = JsonQueryUtil.query(this.query);
        }
        catch (IOException e) {
            Logging.warn((String)(e.getClass().getName() + " while connecting to a chat server: " + e.getMessage()));
            obj = null;
        }
        if (this.callback != null) {
            this.callback.processJson(obj);
        }
    }

    @Override
    public void run() {
        if (EventQueue.isDispatchThread()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JsonQueryUtil.this.doRealRun();
                }
            }).start();
        } else {
            this.doRealRun();
        }
    }
}

