/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.tag2link.Tag2LinkConstants;
import org.openstreetmap.josm.plugins.tag2link.data.Link;
import org.openstreetmap.josm.plugins.tag2link.data.LinkPost;
import org.openstreetmap.josm.plugins.tag2link.data.Rule;
import org.openstreetmap.josm.plugins.tag2link.data.Source;
import org.openstreetmap.josm.plugins.tag2link.io.SourcesReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class Tag2LinkRuleChecker
implements Tag2LinkConstants {
    private static Collection<Source> sources = new ArrayList<Source>();
    private static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            sources = SourcesReader.readSources();
            initialized = true;
        }
    }

    private static String findValue(String arg, Collection<Rule.MatchingTag> matchingTags) {
        for (Rule.MatchingTag tag : matchingTags) {
            if (!tag.params.containsKey(arg)) continue;
            return tag.params.get(arg);
        }
        return null;
    }

    private static String replaceParams(String s, Rule.EvalResult eval) {
        String result = s;
        Matcher m = Pattern.compile("%([^%]*)%").matcher(s);
        while (m.find()) {
            Matcher lm;
            String arg = m.group(1);
            String val = Tag2LinkRuleChecker.findValue(arg, eval.matchingTags);
            if (val == null && (lm = Pattern.compile(".*lang(?:\\((\\p{Lower}{2,})(?:,(\\p{Lower}{2,}))*\\))?.*").matcher(arg)).matches()) {
                String josmLang = Config.getPref().get("language");
                String jvmLang = (josmLang.isEmpty() ? Locale.getDefault().getLanguage() : josmLang).split("_")[0];
                if (lm.groupCount() == 0) {
                    val = jvmLang;
                } else {
                    for (int i = 1; i <= lm.groupCount() && val == null; ++i) {
                        if (!jvmLang.equals(lm.group(i))) continue;
                        val = jvmLang;
                    }
                }
            }
            if (val == null && arg.contains(":")) {
                String[] vars = arg.split(":");
                for (int i = 0; val == null && i < vars.length - 1; ++i) {
                    val = Tag2LinkRuleChecker.findValue(vars[i], eval.matchingTags);
                }
                if (val == null) {
                    val = vars[vars.length - 1];
                }
            }
            if (val != null) {
                try {
                    if (s.contains("wikipedia.") || s.contains(".wikimedia.org")) {
                        val = val.replaceAll(" ", "_");
                    }
                    if (!m.group().equals(s)) {
                        val = URLEncoder.encode(val, "UTF-8");
                    }
                    result = result.replaceFirst(Pattern.quote(m.group()), val);
                }
                catch (UnsupportedEncodingException e) {
                    Logging.error((Throwable)e);
                }
                continue;
            }
            System.err.println("Invalid argument: " + arg);
        }
        return result;
    }

    private static void replaceMapParams(Map<String, String> map, Rule.EvalResult eval) {
        for (String key : map.keySet()) {
            String value = map.get(key);
            String key2 = Tag2LinkRuleChecker.replaceParams(key, eval);
            String value2 = Tag2LinkRuleChecker.replaceParams(value, eval);
            if (key.equals(key2) && value.equals(value2)) continue;
            if (key.equals(key2)) {
                map.put(key, value2);
                continue;
            }
            map.remove(key);
            map.put(key2, value2);
        }
    }

    private static Collection<Link> processEval(Rule.EvalResult eval, Rule rule, Source source) {
        ArrayList<Link> result = new ArrayList<Link>();
        if (eval.matches()) {
            for (Link link : rule.links) {
                try {
                    Link copy = link.clone();
                    copy.name = copy.name.replaceAll("%name%", source.name);
                    copy.url = Tag2LinkRuleChecker.replaceParams(copy.url, eval);
                    if (copy instanceof LinkPost) {
                        LinkPost lp = (LinkPost)copy;
                        Tag2LinkRuleChecker.replaceMapParams(lp.headers, eval);
                        Tag2LinkRuleChecker.replaceMapParams(lp.params, eval);
                    }
                    result.add(copy);
                }
                catch (CloneNotSupportedException e) {
                    System.err.println(e);
                }
            }
        }
        return result;
    }

    public static Collection<Link> getLinks(IPrimitive p) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Source source : sources) {
            for (Rule rule : source.rules) {
                result.addAll(Tag2LinkRuleChecker.processEval(rule.evaluates(p), rule, source));
            }
        }
        return result;
    }

    public static Collection<Link> getLinks(Tag tag) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Source source : sources) {
            for (Rule rule : source.rules) {
                result.addAll(Tag2LinkRuleChecker.processEval(rule.evaluates(tag), rule, source));
            }
        }
        return result;
    }
}

