/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.kaintoch.gps.globalsat.dg100.Dg100Config;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatConfigDialog;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatDg100;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatPlugin;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class GlobalsatImportDialog
extends JPanel {
    private JCheckBox delete;
    private JComboBox<CommPortIdentifier> portCombo;

    public GlobalsatImportDialog() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.portCombo = new JComboBox();
        this.portCombo.setRenderer(new ListCellRenderer<CommPortIdentifier>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends CommPortIdentifier> list, CommPortIdentifier o, int x, boolean a, boolean b) {
                String value = o.getName();
                if (value == null) {
                    value = "null";
                }
                return new JLabel(value);
            }
        });
        this.portCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object i = GlobalsatImportDialog.this.portCombo.getSelectedItem();
                if (i instanceof CommPortIdentifier) {
                    GlobalsatPlugin.setPortIdent((CommPortIdentifier)i);
                    Config.getPref().put("globalsat.portIdentifier", ((CommPortIdentifier)i).getName());
                }
            }
        });
        this.refreshPorts();
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = 1;
        c.weightx = 0.8;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel(I18n.tr((String)"Port:", (Object[])new Object[0])), c);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.5;
        this.add(this.portCombo, c);
        JButton refreshBtn = new JButton(I18n.tr((String)"Refresh", (Object[])new Object[0]));
        refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalsatImportDialog.this.refreshPorts();
            }
        });
        refreshBtn.setToolTipText(I18n.tr((String)"refresh the port list", (Object[])new Object[0]));
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 0;
        this.add((Component)refreshBtn, c);
        JButton configBtn = new JButton(I18n.tr((String)"Configure", (Object[])new Object[0]));
        configBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("configuring the device");
                try {
                    Dg100Config conf = GlobalsatPlugin.dg100().getConfig();
                    if (conf != null) {
                        GlobalsatConfigDialog dialog = new GlobalsatConfigDialog(conf);
                        JOptionPane pane = new JOptionPane(dialog, -1, 2);
                        JDialog dlg = pane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Configure Device", (Object[])new Object[0]));
                        dlg.setVisible(true);
                        if ((Integer)pane.getValue() == 0) {
                            GlobalsatPlugin.dg100().setConfig(dialog.getConfig());
                        }
                        dlg.dispose();
                    } else {
                        JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Connection Error.", (Object[])new Object[0]), I18n.tr((String)"Connection Error.", (Object[])new Object[0]), 64);
                    }
                }
                catch (GlobalsatDg100.ConnectionException ex) {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), String.valueOf(I18n.tr((String)"Connection Error.", (Object[])new Object[0])) + " " + ex.toString());
                }
                System.out.println("configuring the device finished");
            }
        });
        configBtn.setToolTipText(I18n.tr((String)"configure the connected DG100", (Object[])new Object[0]));
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 1;
        this.add((Component)configBtn, c);
        this.delete = new JCheckBox(I18n.tr((String)"delete data after import", (Object[])new Object[0]));
        this.delete.setSelected(Config.getPref().getBoolean("globalsat.deleteAfterDownload", false));
        c.gridwidth = 3;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.delete, c);
    }

    public void refreshPorts() {
        String sel = Config.getPref().get("globalsat.portIdentifier");
        this.portCombo.setVisible(false);
        this.portCombo.removeAllItems();
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            CommPortIdentifier port = (CommPortIdentifier)e.nextElement();
            if (port.getPortType() != 1) continue;
            this.portCombo.addItem(port);
            if (sel == null || port.getName() != sel) continue;
            this.portCombo.setSelectedItem(port);
            GlobalsatPlugin.setPortIdent(port);
        }
        this.portCombo.setVisible(true);
        GlobalsatPlugin.setPortIdent(this.getPort());
    }

    public boolean deleteFilesAfterDownload() {
        return this.delete.isSelected();
    }

    public CommPortIdentifier getPort() {
        return (CommPortIdentifier)this.portCombo.getSelectedItem();
    }
}

