/*
 * Decompiled with CFR 0.152.
 */
package org.kaintoch.gps.globalsat.dg100;

public class ByteHelper {
    public static int copyByteArr2ByteArr(byte[] src, int startS, int len, byte[] dest, int startD) {
        int ii = 0;
        while (ii < len && startD < dest.length && startS < src.length && startD >= 0 && startS >= 0) {
            dest[startD] = src[startS];
            ++ii;
            ++startD;
            ++startS;
        }
        return startD;
    }

    public static int byte2IntUnsigned(byte byt) {
        return byt >= 0 ? byt : 256 + byt;
    }

    private static char nibble2Char(int nibble) {
        char chr = '*';
        switch (nibble &= 0xF) {
            case 0: {
                chr = '0';
                break;
            }
            case 1: {
                chr = '1';
                break;
            }
            case 2: {
                chr = '2';
                break;
            }
            case 3: {
                chr = '3';
                break;
            }
            case 4: {
                chr = '4';
                break;
            }
            case 5: {
                chr = '5';
                break;
            }
            case 6: {
                chr = '6';
                break;
            }
            case 7: {
                chr = '7';
                break;
            }
            case 8: {
                chr = '8';
                break;
            }
            case 9: {
                chr = '9';
                break;
            }
            case 10: {
                chr = 'A';
                break;
            }
            case 11: {
                chr = 'B';
                break;
            }
            case 12: {
                chr = 'C';
                break;
            }
            case 13: {
                chr = 'D';
                break;
            }
            case 14: {
                chr = 'E';
                break;
            }
            case 15: {
                chr = 'F';
            }
        }
        return chr;
    }

    public static String byte2StringUnsigned(byte byt) {
        StringBuffer buf = new StringBuffer(4);
        int bb = ByteHelper.byte2IntUnsigned(byt);
        buf.append(ByteHelper.nibble2Char(bb / 16));
        buf.append(ByteHelper.nibble2Char(bb % 16));
        return buf.toString();
    }

    public static String byteArray2String(byte[] byt) {
        return ByteHelper.byteArray2String(byt, byt.length);
    }

    public static String byteArray2String(byte[] byt, int cnt) {
        StringBuffer buf = new StringBuffer(cnt * 5);
        int ii = 0;
        while (ii < cnt && ii < byt.length) {
            if (ii > 0) {
                buf.append(" ");
            }
            buf.append(ByteHelper.byte2StringUnsigned(byt[ii]));
            ++ii;
        }
        return buf.toString();
    }
}

