/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class ReconstructPolygonAction
extends AbstractAction
implements ChosenRelationListener {
    private ChosenRelation rel;
    private static final List<String> IRRELEVANT_KEYS = Arrays.asList("source", "created_by", "note");

    public ReconstructPolygonAction(ChosenRelation rel) {
        super(I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"filter"));
        this.putValue("LongDescription", "Reconstruct polygon from multipolygon relation");
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(this.isSuitableRelation(rel.get()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation r = this.rel.get();
        boolean relationReused = false;
        ArrayList<Way> ways = new ArrayList<Way>();
        boolean wont = false;
        for (RelationMember m : r.getMembers()) {
            if (m.isWay()) {
                ways.add(m.getWay());
                continue;
            }
            wont = true;
        }
        if (wont) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Multipolygon must consist only of ways", (Object[])new Object[0]), I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]), 0);
            return;
        }
        MultipolygonBuilder mpc = new MultipolygonBuilder();
        String error = mpc.makeFromWays(ways);
        if (error != null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), error);
            return;
        }
        this.rel.clear();
        ArrayList<Object> newSelection = new ArrayList<Object>();
        ArrayList<Object> commands = new ArrayList<Object>();
        Command relationDeleteCommand = DeleteCommand.delete(Collections.singleton(r), (boolean)true, (boolean)true);
        if (relationDeleteCommand == null) {
            return;
        }
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        for (MultipolygonBuilder.JoinedPolygon p : mpc.outerWays) {
            ArrayList<MultipolygonBuilder.JoinedPolygon> myInnerWays = new ArrayList<MultipolygonBuilder.JoinedPolygon>();
            for (MultipolygonBuilder.JoinedPolygon i : mpc.innerWays) {
                EastNorth en = ((Way)i.ways.get(0)).firstNode().getEastNorth();
                if (!p.area.contains(en.east(), en.north())) continue;
                myInnerWays.add(i);
            }
            if (!myInnerWays.isEmpty()) {
                Relation n = null;
                if (relationReused) {
                    n = new Relation();
                    n.setKeys(r.getKeys());
                } else {
                    n = new Relation(r);
                    n.setMembers(null);
                }
                for (Way w : p.ways) {
                    n.addMember(new RelationMember("outer", (OsmPrimitive)w));
                }
                for (MultipolygonBuilder.JoinedPolygon i : myInnerWays) {
                    for (Way w : i.ways) {
                        n.addMember(new RelationMember("inner", (OsmPrimitive)w));
                    }
                }
                if (relationReused) {
                    commands.add(new AddCommand(ds, (OsmPrimitive)n));
                } else {
                    relationReused = true;
                    commands.add(new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)n));
                }
                newSelection.add(n);
                continue;
            }
            TagMap tags = ((Way)p.ways.get(0)).getKeys();
            if (!((Way)p.ways.get(0)).hasAreaTags()) {
                tags.clear();
            }
            List relations = ((Way)p.ways.get(0)).getReferrers();
            HashSet<String> noTags = new HashSet<String>(r.keySet());
            int i = 1;
            while (i < p.ways.size()) {
                Way w = (Way)p.ways.get(i);
                for (String key : w.keySet()) {
                    String value = w.get(key);
                    if (noTags.contains(key) || !tags.containsKey(key) || ((String)tags.get(key)).equals(value)) continue;
                    tags.remove(key);
                    noTags.add(key);
                }
                List referrers = w.getReferrers();
                Iterator ref1 = relations.iterator();
                while (ref1.hasNext()) {
                    if (referrers.contains(ref1.next())) continue;
                    ref1.remove();
                }
                ++i;
            }
            tags.putAll(r.getKeys());
            tags.remove("type");
            Way candidateWay = null;
            for (Way w : p.ways) {
                if (!w.getReferrers().equals(relations)) continue;
                HashSet keys = new HashSet(w.keySet());
                keys.removeAll(tags.keySet());
                keys.removeAll(IRRELEVANT_KEYS);
                if (!keys.isEmpty()) continue;
                if (candidateWay == null) {
                    candidateWay = w;
                    continue;
                }
                if (candidateWay.isNew() && !w.isNew()) {
                    Way tmp = w;
                    w = candidateWay;
                    candidateWay = tmp;
                }
                commands.add(new DeleteCommand((OsmPrimitive)w));
            }
            Way result = candidateWay == null ? new Way() : new Way(candidateWay);
            result.setNodes(p.nodes);
            result.addNode(result.firstNode());
            result.setKeys((Map)tags);
            newSelection.add(candidateWay == null ? result : candidateWay);
            commands.add(candidateWay == null ? new AddCommand(ds, (OsmPrimitive)result) : new ChangeCommand((OsmPrimitive)candidateWay, (OsmPrimitive)result));
        }
        if (!relationReused) {
            commands.add(relationDeleteCommand);
        }
        UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Reconstruct polygons from relation {0}", (Object[])new Object[]{r.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
        ds.setSelected(newSelection);
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(this.isSuitableRelation(newRelation));
    }

    private boolean isSuitableRelation(Relation newRelation) {
        return newRelation != null && "multipolygon".equals(newRelation.get("type")) && newRelation.getMembersCount() != 0;
    }
}

