/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery_offset_db;

import java.text.MessageFormat;
import java.util.List;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryIdGenerator;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffset;
import org.openstreetmap.josm.tools.I18n;

public final class ImageryOffsetTools {
    public static final String DIALOG_TITLE = I18n.tr((String)"Imagery Offset Database", (Object[])new Object[0]);

    private ImageryOffsetTools() {
    }

    public static AbstractTileSourceLayer<?> getTopImageryLayer() {
        if (!MainApplication.isDisplayingMapView()) {
            return null;
        }
        List layers = MainApplication.getLayerManager().getLayersOfType(AbstractTileSourceLayer.class);
        for (AbstractTileSourceLayer layer : layers) {
            String url = layer.getInfo().getUrl();
            if (!layer.isVisible() || url == null || url.contains("gps-")) continue;
            return layer;
        }
        return null;
    }

    public static LatLon getMapCenter() {
        Projection proj = ProjectionRegistry.getProjection();
        return !MainApplication.isDisplayingMapView() ? new LatLon(0.0, 0.0) : proj.eastNorth2latlon(MainApplication.getMap().mapView.getCenter());
    }

    public static LatLon getLayerOffset(AbstractTileSourceLayer<?> layer, LatLon center) {
        Projection proj = ProjectionRegistry.getProjection();
        EastNorth offsetCenter = MainApplication.getMap().mapView.getCenter();
        EastNorth centerOffset = offsetCenter.add(-layer.getDisplaySettings().getDx(), -layer.getDisplaySettings().getDy());
        LatLon offsetLL = proj.eastNorth2latlon(centerOffset);
        return offsetLL;
    }

    public static void applyLayerOffset(AbstractTileSourceLayer<?> layer, ImageryOffset offset) {
        OffsetBookmark bookmark = ImageryOffsetTools.calculateOffset(offset);
        layer.getDisplaySettings().setOffsetBookmark(bookmark);
    }

    public static OffsetBookmark calculateOffset(ImageryOffset offset) {
        Projection proj = ProjectionRegistry.getProjection();
        EastNorth center = proj.latlon2eastNorth(offset.getPosition());
        EastNorth offsetPos = proj.latlon2eastNorth(offset.getImageryPos());
        EastNorth offsetXY = new EastNorth(center.getX() - offsetPos.getX(), center.getY() - offsetPos.getY());
        OffsetBookmark b = new OffsetBookmark(proj.toCode(), null, offset.getImagery(), "Autogenerated", offsetXY.getX(), offsetXY.getY(), offset.getPosition().lon(), offset.getPosition().lat());
        return b;
    }

    public static String getImageryID(AbstractTileSourceLayer<?> layer) {
        return layer == null ? null : ImageryIdGenerator.getImageryID(layer.getInfo().getUrl(), layer.getInfo().getImageryType());
    }

    private static double latToTileY(double lat, int zoom) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return Math.pow(2.0, zoom - 1) * (Math.PI - pf) / Math.PI;
    }

    private static double lonToTileX(double lon, int zoom) {
        return Math.pow(2.0, zoom - 3) * (lon + 180.0) / 45.0;
    }

    public static int getCurrentZoom() {
        if (!MainApplication.isDisplayingMapView()) {
            return 1;
        }
        MapView mv = MainApplication.getMap().mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        double x1 = ImageryOffsetTools.lonToTileX(topLeft.lon(), 1);
        double y1 = ImageryOffsetTools.latToTileY(topLeft.lat(), 1);
        double x2 = ImageryOffsetTools.lonToTileX(botRight.lon(), 1);
        double y2 = ImageryOffsetTools.latToTileY(botRight.lat(), 1);
        int screenPixels = mv.getWidth() * mv.getHeight();
        double tilePixels = Math.abs((y2 - y1) * (x2 - x1) * 256.0 * 256.0);
        if (screenPixels == 0 || tilePixels == 0.0) {
            return 1;
        }
        double factor = (double)screenPixels / tilePixels;
        double result = Math.log(factor) / Math.log(2.0) / 2.0 + 1.0;
        int intResult = (int)Math.floor(result);
        return intResult;
    }

    public static String formatDistance(double d) {
        if (d < 0.0095) {
            return ImageryOffsetTools.formatDistance(d * 1000.0, I18n.tr((String)"mm", (Object[])new Object[0]), true);
        }
        if (d < 0.095) {
            return ImageryOffsetTools.formatDistance(d * 100.0, I18n.tr((String)"cm", (Object[])new Object[0]), true);
        }
        if (d < 0.95) {
            return ImageryOffsetTools.formatDistance(d * 100.0, I18n.tr((String)"cm", (Object[])new Object[0]), false);
        }
        if (d < 9.5) {
            return ImageryOffsetTools.formatDistance(d, I18n.tr((String)"m", (Object[])new Object[0]), true);
        }
        if (d < 950.0) {
            return ImageryOffsetTools.formatDistance(d, I18n.tr((String)"m", (Object[])new Object[0]), false);
        }
        if (d < 9500.0) {
            return ImageryOffsetTools.formatDistance(d / 1000.0, I18n.tr((String)"km", (Object[])new Object[0]), true);
        }
        if (d < 1000000.0) {
            return ImageryOffsetTools.formatDistance(d / 1000.0, I18n.tr((String)"km", (Object[])new Object[0]), false);
        }
        return "\u221e";
    }

    private static String formatDistance(double d, String si, boolean floating) {
        return MessageFormat.format(floating ? "{0,number,0.0} {1}" : "{0,number,0} {1}", d, si);
    }
}

