/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Bag;
import edu.princeton.cs.algs4.DirectedEdge;
import edu.princeton.cs.algs4.Stack;

public class EdgeWeightedDigraph {
    private final int V;
    private int E;
    private Bag<DirectedEdge>[] adj;

    public EdgeWeightedDigraph(int V) {
        if (V < 0) {
            throw new RuntimeException("Number of vertices must be nonnegative");
        }
        this.V = V;
        this.E = 0;
        this.adj = new Bag[V];
        int v = 0;
        while (v < V) {
            this.adj[v] = new Bag();
            ++v;
        }
    }

    public EdgeWeightedDigraph(int V, int E) {
        this(V);
        if (E < 0) {
            throw new RuntimeException("Number of edges must be nonnegative");
        }
        int i = 0;
        while (i < E) {
            int v = (int)(Math.random() * (double)V);
            int w = (int)(Math.random() * (double)V);
            double weight = (double)Math.round(100.0 * Math.random()) / 100.0;
            DirectedEdge e = new DirectedEdge(v, w, weight);
            this.addEdge(e);
            ++i;
        }
    }

    public EdgeWeightedDigraph(EdgeWeightedDigraph G) {
        this(G.V());
        this.E = G.E();
        int v = 0;
        while (v < G.V()) {
            Stack<DirectedEdge> reverse = new Stack<DirectedEdge>();
            for (DirectedEdge e : G.adj[v]) {
                reverse.push(e);
            }
            for (DirectedEdge e : reverse) {
                this.adj[v].add(e);
            }
            ++v;
        }
    }

    public int V() {
        return this.V;
    }

    public int E() {
        return this.E;
    }

    public void addEdge(DirectedEdge e) {
        int v = e.from();
        this.adj[v].add(e);
        ++this.E;
    }

    public Iterable<DirectedEdge> adj(int v) {
        return this.adj[v];
    }

    public Iterable<DirectedEdge> edges() {
        Bag<DirectedEdge> list = new Bag<DirectedEdge>();
        int v = 0;
        while (v < this.V) {
            for (DirectedEdge e : this.adj(v)) {
                list.add(e);
            }
            ++v;
        }
        return list;
    }

    public int outdegree(int v) {
        return this.adj[v].size();
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(this.V) + " " + this.E + NEWLINE);
        int v = 0;
        while (v < this.V) {
            s.append(String.valueOf(v) + ": ");
            for (DirectedEdge e : this.adj[v]) {
                s.append(e + "  ");
            }
            s.append(NEWLINE);
            ++v;
        }
        return s.toString();
    }
}

