/*
 * Decompiled with CFR 0.152.
 */
package reverter.corehacks;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import reverter.corehacks.ChangesetDataSet;

public class OsmChangesetContentParser {
    private final InputSource source;
    private final ChangesetDataSet data;

    public OsmChangesetContentParser(InputStream source) throws UnsupportedEncodingException {
        CheckParameterUtil.ensureParameterNotNull((Object)source, (String)"source");
        this.source = new InputSource(new InputStreamReader(source, "UTF-8"));
        this.data = new ChangesetDataSet();
    }

    public OsmChangesetContentParser(String source) {
        CheckParameterUtil.ensureParameterNotNull((Object)source, (String)"source");
        this.source = new InputSource(new StringReader(source));
        this.data = new ChangesetDataSet();
    }

    public ChangesetDataSet parse(ProgressMonitor progressMonitor) throws XmlParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Parsing changeset content ...", (Object[])new Object[0]));
            SAXParserFactory.newInstance().newSAXParser().parse(this.source, (DefaultHandler)new Parser());
        }
        catch (XmlParsingException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw new XmlParsingException((Exception)e);
        }
        catch (SAXException e) {
            throw new XmlParsingException((Exception)e);
        }
        catch (IOException e) {
            throw new XmlParsingException((Exception)e);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    public ChangesetDataSet parse() throws XmlParsingException {
        return this.parse(null);
    }

    private class Parser
    extends DefaultHandler {
        private HistoryOsmPrimitive currentPrimitive;
        private ChangesetDataSet.ChangesetModificationType currentModificationType;
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String message) throws XmlParsingException {
            throw new XmlParsingException(message).rememberLocation(this.locator);
        }

        protected void throwException(Exception e) throws XmlParsingException {
            throw new XmlParsingException(e).rememberLocation(this.locator);
        }

        protected long getMandatoryAttributeLong(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}''.", (Object[])new Object[]{name}));
            }
            Long l = 0L;
            try {
                l = Long.parseLong(v);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", (Object[])new Object[]{name, v}));
            }
            if (l < 0L) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", (Object[])new Object[]{name, v}));
            }
            return l;
        }

        protected Double getAttributeDouble(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                return null;
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(v);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr((String)"Illegal value for attribute ''{0}'' of type double. Got ''{1}''.", (Object[])new Object[]{name, v}));
            }
            return d;
        }

        protected String getMandatoryAttributeString(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}''.", (Object[])new Object[]{name}));
            }
            return v;
        }

        protected boolean getMandatoryAttributeBoolean(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}''.", (Object[])new Object[]{name}));
            }
            if ("true".equals(v)) {
                return true;
            }
            if ("false".equals(v)) {
                return false;
            }
            this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type boolean. Got ''{1}''.", (Object[])new Object[]{name, v}));
            return false;
        }

        protected HistoryOsmPrimitive createPrimitive(Attributes atts, OsmPrimitiveType type) throws SAXException {
            long id = this.getMandatoryAttributeLong(atts, "id");
            long version = this.getMandatoryAttributeLong(atts, "version");
            long changesetId = this.getMandatoryAttributeLong(atts, "changeset");
            boolean visible = this.getMandatoryAttributeBoolean(atts, "visible");
            String v = this.getMandatoryAttributeString(atts, "timestamp");
            Date timestamp = DateUtils.fromString((String)v);
            HistoryWay primitive = null;
            if (type.equals((Object)OsmPrimitiveType.NODE)) {
                Double lat = this.getAttributeDouble(atts, "lat");
                Double lon = this.getAttributeDouble(atts, "lon");
                LatLon coor = lat != null && lon != null ? new LatLon(lat.doubleValue(), lon.doubleValue()) : null;
                primitive = new HistoryNode(id, version, visible, User.getAnonymous(), changesetId, timestamp, coor);
            } else if (type.equals((Object)OsmPrimitiveType.WAY)) {
                primitive = new HistoryWay(id, version, visible, User.getAnonymous(), changesetId, timestamp);
            } else if (type.equals((Object)OsmPrimitiveType.RELATION)) {
                primitive = new HistoryRelation(id, version, visible, User.getAnonymous(), changesetId, timestamp);
            }
            return primitive;
        }

        protected void startNode(Attributes atts) throws SAXException {
            this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.NODE);
        }

        protected void startWay(Attributes atts) throws SAXException {
            this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.WAY);
        }

        protected void startRelation(Attributes atts) throws SAXException {
            this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.RELATION);
        }

        protected void handleTag(Attributes atts) throws SAXException {
            String key = this.getMandatoryAttributeString(atts, "k");
            String value = this.getMandatoryAttributeString(atts, "v");
            this.currentPrimitive.put(key, value);
        }

        protected void handleNodeReference(Attributes atts) throws SAXException {
            long ref = this.getMandatoryAttributeLong(atts, "ref");
            ((HistoryWay)this.currentPrimitive).addNode(ref);
        }

        protected void handleMember(Attributes atts) throws SAXException {
            long ref = this.getMandatoryAttributeLong(atts, "ref");
            String v = this.getMandatoryAttributeString(atts, "type");
            OsmPrimitiveType type = null;
            try {
                type = OsmPrimitiveType.fromApiTypeName((String)v);
            }
            catch (IllegalArgumentException e) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type OsmPrimitiveType. Got ''{1}''.", (Object[])new Object[]{"type", v}));
            }
            String role = this.getMandatoryAttributeString(atts, "role");
            RelationMemberData member = new RelationMemberData(role, type, ref);
            ((HistoryRelation)this.currentPrimitive).addMember(member);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("node")) {
                this.startNode(atts);
            } else if (qName.equals("way")) {
                this.startWay(atts);
            } else if (qName.equals("relation")) {
                this.startRelation(atts);
            } else if (qName.equals("tag")) {
                this.handleTag(atts);
            } else if (qName.equals("nd")) {
                this.handleNodeReference(atts);
            } else if (qName.equals("member")) {
                this.handleMember(atts);
            } else if (!qName.equals("osmChange")) {
                if (qName.equals("create")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.CREATED;
                } else if (qName.equals("modify")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.UPDATED;
                } else if (qName.equals("delete")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.DELETED;
                } else {
                    System.err.println(I18n.tr((String)"Warning: unsupported start element ''{0}'' in changeset content at position ({1},{2}). Skipping.", (Object[])new Object[]{qName, this.locator.getLineNumber(), this.locator.getColumnNumber()}));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("node") || qName.equals("way") || qName.equals("relation")) {
                if (this.currentModificationType == null) {
                    this.throwException(I18n.tr((String)"Illegal document structure. Found node, way, or relation outside of ''create'', ''modify'', or ''delete''.", (Object[])new Object[0]));
                }
                OsmChangesetContentParser.this.data.put(this.currentPrimitive, this.currentModificationType);
            } else if (!qName.equals("osmChange")) {
                if (qName.equals("create")) {
                    this.currentModificationType = null;
                } else if (qName.equals("modify")) {
                    this.currentModificationType = null;
                } else if (qName.equals("delete")) {
                    this.currentModificationType = null;
                } else if (!(qName.equals("tag") || qName.equals("nd") || qName.equals("member"))) {
                    System.err.println(I18n.tr((String)"Warning: unsupported end element ''{0}'' in changeset content at position ({1},{2}). Skipping.", (Object[])new Object[]{qName, this.locator.getLineNumber(), this.locator.getColumnNumber()}));
                }
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.throwException(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.throwException(e);
        }
    }
}

