/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import reverter.MultiOsmReader;

public class OsmServerMultiObjectReader
extends OsmServerReader {
    private final MultiOsmReader rdr = new MultiOsmReader();

    public void readObject(PrimitiveId id, int version, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.readObject(id.getUniqueId(), version, id.getType(), progressMonitor);
    }

    public void readObject(long id, int version, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getAPIName());
        sb.append("/");
        sb.append(id);
        sb.append("/");
        sb.append(version);
        progressMonitor.beginTask("", 1);
        try (InputStream in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));){
            this.rdr.addData(in);
        }
        catch (IOException | IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        progressMonitor.subTask(I18n.tr((String)"Preparing history data...", (Object[])new Object[0]));
        try {
            this.rdr.processData();
            DataSet dataSet = this.rdr.getDataSet();
            return dataSet;
        }
        catch (Exception e) {
            throw new OsmTransferException((Throwable)e);
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }
}

