/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractIdTextField;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetIdsTextField
extends AbstractIdTextField<OsmIdsValidator> {
    public ChangesetIdsTextField() {
        super(OsmIdsValidator.class);
    }

    public boolean readIds() {
        return ((OsmIdsValidator)this.validator).readChangesetIds();
    }

    public Collection<Integer> getIdsInReverseOrder() {
        return ((OsmIdsValidator)this.validator).ids;
    }

    public static class OsmIdsValidator
    extends AbstractTextComponentValidator {
        private Collection<Integer> ids = new TreeSet(Collections.reverseOrder());

        public OsmIdsValidator(JTextComponent tc) {
            super(tc);
        }

        public void validate() {
            String help = I18n.tr((String)"Please enter one or more integer values > 0 or full changeset URLs.", (Object[])new Object[0]);
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr((String)"The current value is not a a list of valid changeset IDs. {0}", (Object[])new Object[]{help}));
            } else {
                this.feedbackValid(help);
            }
        }

        public boolean readChangesetIds() {
            this.ids.clear();
            String value = this.getComponent().getText();
            try {
                StringTokenizer tokenizer = new StringTokenizer(value, ",+ \t\n");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    if (token.matches("http.*/changeset/[0-9]+")) {
                        token = token.substring(token.lastIndexOf(47) + 1);
                    }
                    this.ids.add(Integer.parseInt(token));
                }
                return true;
            }
            catch (NumberFormatException e) {
                this.ids.clear();
                return false;
            }
        }

        public boolean isValid() {
            return this.readChangesetIds();
        }
    }
}

