/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.CollectionUtils;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;
import org.openstreetmap.josm.tools.Pair;

public final class ModelContainer {
    private static final ModelContainer EMPTY = new ModelContainer(Collections.emptySet(), Collections.emptySet(), false);
    private final Map<Node, Junction> junctions = new HashMap<Node, Junction>();
    private final Map<Way, Road> roads = new HashMap<Way, Road>();
    private final Set<Node> primaryNodes;
    private final Set<Way> primaryWays;
    private final boolean empty;

    public static ModelContainer create(Iterable<Node> primaryNodes, Iterable<Way> primaryWays) {
        return new ModelContainer(new HashSet<Node>(CollectionUtils.toList(primaryNodes)), new HashSet<Way>(CollectionUtils.toList(primaryWays)), false);
    }

    public static ModelContainer createEmpty(Iterable<Node> primaryNodes, Iterable<Way> primaryWays) {
        return new ModelContainer(new HashSet<Node>(CollectionUtils.toList(primaryNodes)), new HashSet<Way>(CollectionUtils.toList(primaryWays)), true);
    }

    public static ModelContainer empty() {
        return EMPTY;
    }

    private static void close(Set<Node> closedNodes, Set<Way> closedWays) {
        boolean closed = false;
        while (!closed) {
            closed = true;
            for (Node n : new ArrayList<Node>(closedNodes)) {
                for (Way w : Utils.filterRoads(n.getReferrers())) {
                    if (!w.isFirstLastNode((INode)n)) continue;
                    closed &= ModelContainer.close(closedNodes, closedWays, w);
                }
                for (Way w : new ArrayList<Way>(closedWays)) {
                    closed &= ModelContainer.close(closedNodes, closedWays, w);
                }
            }
        }
    }

    private static boolean close(Set<Node> closedNodes, Set<Way> closedWays, Way w) {
        boolean closed = true;
        for (Relation r : org.openstreetmap.josm.tools.Utils.filteredCollection((Collection)w.getReferrers(), Relation.class)) {
            if (!r.get("type").equals("turnlanes:turns")) continue;
            for (RelationMember m : r.getMembers()) {
                if (!m.getRole().equals("via") || !m.getMember().equals((Object)w)) continue;
                closed &= ModelContainer.close(closedNodes, closedWays, r);
            }
        }
        return closed;
    }

    private static boolean close(Set<Node> closedNodes, Set<Way> closedWays, Relation r) {
        boolean closed = true;
        ArrayList<Way> via = new ArrayList<Way>();
        for (RelationMember m : Utils.getMembers(r, "via")) {
            if (m.isWay()) {
                closed &= !closedWays.add(m.getWay());
                via.add(m.getWay());
                continue;
            }
            if (!m.isNode()) continue;
            closed &= !closedNodes.add(m.getNode());
        }
        if (!via.isEmpty()) {
            Way from = Utils.getMemberWay(r, "from");
            Way to = Utils.getMemberWay(r, "to");
            closed &= !closedNodes.add(Utils.lineUp(from, (Way)via.get(0)));
            closed &= !closedNodes.add(Utils.lineUp((Way)via.get(via.size() - 1), to));
        }
        return closed;
    }

    private static <E extends OsmPrimitive, C extends Collection<E>> C filterUsables(C collection) {
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            OsmPrimitive e = (OsmPrimitive)it.next();
            if (e.getDataSet() != null && e.isUsable()) continue;
            it.remove();
        }
        return collection;
    }

    private ModelContainer(Set<Node> primaryNodes, Set<Way> primaryWays, boolean empty) {
        if (empty) {
            this.primaryNodes = Collections.unmodifiableSet(new HashSet<Node>(primaryNodes));
            this.primaryWays = Collections.unmodifiableSet(new HashSet<Way>(primaryWays));
            this.empty = true;
        } else {
            Set closedNodes = ModelContainer.filterUsables(new HashSet<Node>(primaryNodes));
            Set closedWays = ModelContainer.filterUsables(new HashSet<Way>(primaryWays));
            ModelContainer.close(closedNodes, closedWays);
            this.primaryNodes = Collections.unmodifiableSet(closedNodes);
            this.primaryWays = Collections.unmodifiableSet(closedWays);
            for (Pair<Way, Junction> pair : this.createPrimaryJunctions()) {
                if (this.primaryWays.contains(pair.a)) continue;
                this.addRoad(new Road(this, (Way)pair.a, (Junction)pair.b));
            }
            for (Route route : Utils.orderWays(this.primaryWays, this.primaryNodes)) {
                this.addRoad(new Road(this, route));
            }
            for (Road road : this.roads.values()) {
                road.initialize();
            }
            this.empty = this.junctions.isEmpty();
        }
    }

    private Set<Pair<Way, Junction>> createPrimaryJunctions() {
        HashSet<Pair<Way, Junction>> roads = new HashSet<Pair<Way, Junction>>();
        for (Node n : this.primaryNodes) {
            ArrayList<Way> ws = new ArrayList<Way>();
            for (Way w : Utils.filterRoads(n.getReferrers())) {
                if (!w.isFirstLastNode((INode)n)) continue;
                ws.add(w);
            }
            if (ws.size() <= 1) continue;
            Junction j = this.register(new Junction(this, n));
            for (Way w : ws) {
                roads.add((Pair<Way, Junction>)new Pair((Object)w, (Object)j));
            }
        }
        return roads;
    }

    Junction getOrCreateJunction(Node n) {
        Junction existing = this.junctions.get(n);
        if (existing != null) {
            return existing;
        }
        return this.register(new Junction(this, n));
    }

    public Junction getJunction(Node n) {
        Junction j = this.junctions.get(n);
        if (j == null) {
            throw new IllegalArgumentException();
        }
        return j;
    }

    Road getRoad(Way w) {
        Road r = this.roads.get(w);
        if (r == null) {
            throw new IllegalArgumentException("There is no road containing the given way.");
        }
        return r;
    }

    private void addRoad(Road newRoad, Road mergedA, Road mergedB) {
        assert (mergedA == null == (mergedB == null));
        for (Route.Segment s : newRoad.getRoute().getSegments()) {
            Road oldRoad = this.roads.put(s.getWay(), newRoad);
            if (oldRoad == null) continue;
            if (mergedA == null) {
                this.addRoad(this.mergeRoads(oldRoad, newRoad), oldRoad, newRoad);
                continue;
            }
            if (oldRoad.equals(mergedA) || oldRoad.equals(mergedB)) continue;
            throw new RuntimeException("A road can't be connected to more than two junctions.");
        }
    }

    private void addRoad(Road newRoad) {
        this.addRoad(newRoad, null, null);
    }

    private Road mergeRoads(Road a, Road b) {
        String ERR_ILLEGAL_ARGS = "The given roads can not be merged into one.";
        ArrayList<Way> ws = new ArrayList<Way>(CollectionUtils.toList(CollectionUtils.reverse(a.getRoute().getWays())));
        List<Way> bws = b.getRoute().getWays();
        int i = -1;
        for (Way w : ws) {
            if (w.equals((Object)bws.get(i + 1))) {
                ++i;
                continue;
            }
            if (i < 0) continue;
            throw new IllegalArgumentException("The given roads can not be merged into one.");
        }
        if (i < 0) {
            throw new IllegalArgumentException("The given roads can not be merged into one.");
        }
        ws.addAll(bws.subList(i + 1, bws.size()));
        Route mergedRoute = Route.create(ws, a.getRoute().getLastSegment().getEnd());
        return new Road(this, mergedRoute);
    }

    private Junction register(Junction j) {
        if (this.junctions.put(j.getNode(), j) != null) {
            throw new IllegalStateException();
        }
        return j;
    }

    public Set<Junction> getPrimaryJunctions() {
        if (this.empty) {
            return Collections.emptySet();
        }
        HashSet<Junction> pjs = new HashSet<Junction>();
        for (Node n : this.primaryNodes) {
            pjs.add(this.getJunction(n));
        }
        return pjs;
    }

    public Set<Road> getPrimaryRoads() {
        if (this.empty) {
            return Collections.emptySet();
        }
        HashSet<Road> prs = new HashSet<Road>();
        for (Way w : this.primaryWays) {
            prs.add(this.roads.get(w));
        }
        return prs;
    }

    public ModelContainer recalculate() {
        return new ModelContainer(this.primaryNodes, this.primaryWays, false);
    }

    public boolean isPrimary(Junction j) {
        return this.primaryNodes.contains(j.getNode());
    }

    public boolean isPrimary(Road r) {
        return this.primaryWays.contains(r.getRoute().getFirstSegment().getWay());
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean hasRoad(Way w) {
        return this.roads.containsKey(w);
    }

    public boolean hasJunction(Node n) {
        return this.junctions.containsKey(n);
    }
}

