/*
 * Decompiled with CFR 0.152.
 */
package s57;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import org.openstreetmap.josm.tools.Logging;
import s57.S57map;
import s57.S57obj;

public final class S57dat {
    private static final EnumMap<S57subf, S57conv> convs = new EnumMap(S57subf.class);
    private static ArrayList<S57subf> S57i8ri;
    private static ArrayList<S57subf> S57dsid;
    private static ArrayList<S57subf> S57dssi;
    private static ArrayList<S57subf> S57dspm;
    private static ArrayList<S57subf> S57dspr;
    private static ArrayList<S57subf> S57dsrc;
    private static ArrayList<S57subf> S57dsht;
    private static ArrayList<S57subf> S57dsac;
    private static ArrayList<S57subf> S57catd;
    private static ArrayList<S57subf> S57catx;
    private static ArrayList<S57subf> S57dddf;
    private static ArrayList<S57subf> S57dddr;
    private static ArrayList<S57subf> S57dddi;
    private static ArrayList<S57subf> S57ddom;
    private static ArrayList<S57subf> S57ddrf;
    private static ArrayList<S57subf> S57ddsi;
    private static ArrayList<S57subf> S57ddsc;
    private static ArrayList<S57subf> S57frid;
    private static ArrayList<S57subf> S57foid;
    private static ArrayList<S57subf> S57lnam;
    private static ArrayList<S57subf> S57attf;
    private static ArrayList<S57subf> S57natf;
    private static ArrayList<S57subf> S57ffpc;
    private static ArrayList<S57subf> S57ffpt;
    private static ArrayList<S57subf> S57fspc;
    private static ArrayList<S57subf> S57fspt;
    private static ArrayList<S57subf> S57vrid;
    private static ArrayList<S57subf> S57attv;
    private static ArrayList<S57subf> S57vrpc;
    private static ArrayList<S57subf> S57vrpt;
    private static ArrayList<S57subf> S57sgcc;
    private static ArrayList<S57subf> S57sg2d;
    private static ArrayList<S57subf> S57sg3d;
    private static ArrayList<S57subf> S57arcc;
    private static ArrayList<S57subf> S57ar2d;
    private static ArrayList<S57subf> S57el2d;
    private static ArrayList<S57subf> S57ct2d;
    private static final EnumMap<S57field, ArrayList<S57subf>> fields;
    private static byte[] leader;
    private static byte[] buffer;
    private static int offset;
    private static int maxoff;
    private static int index;
    private static S57field field;
    private static String aall;
    private static String nall;
    public static int rnum;
    static boolean asc;
    private static final EnumMap<S57obj.Obj, Prims> S57prims;

    private S57dat() {
    }

    private static S57conv findSubf(S57subf subf) {
        ArrayList<S57subf> subs = fields.get((Object)field);
        boolean wrap = false;
        while (true) {
            if (index == subs.size()) {
                if (!wrap) {
                    index = 0;
                    wrap = true;
                } else {
                    System.out.println("ERROR: Subfield not found " + subf.name() + " in " + field.name() + " in record " + rnum);
                    System.exit(-1);
                }
            }
            S57subf sub = subs.get(index++);
            S57conv conv = convs.get((Object)sub);
            if (sub == subf) {
                return conv;
            }
            offset += conv.bin != 0 ? (conv.bin < 8 ? Math.abs(conv.bin) : conv.bin / 8) : conv.asc;
        }
    }

    public static void setField(byte[] buf, int off, S57field fld, int len) {
        buffer = buf;
        offset = off;
        maxoff = off + len - 1;
        field = fld;
        index = 0;
    }

    public static boolean more() {
        return offset < maxoff;
    }

    public static Object decSubf(byte[] buf, int off, S57field fld, S57subf subf) {
        buffer = buf;
        offset = off;
        index = 0;
        return S57dat.decSubf(fld, subf);
    }

    public static Object decSubf(S57field fld, S57subf subf) {
        field = fld;
        index = 0;
        return S57dat.decSubf(subf);
    }

    public static Object decSubf(S57subf subf) {
        S57conv conv = S57dat.findSubf(subf);
        if (conv.bin == 0) {
            String str = "";
            int i = 0;
            if (conv.asc == 0) {
                i = 0;
                while (buffer[offset + i] != 31) {
                    ++i;
                }
                try {
                    String charset = "";
                    charset = field == S57field.ATTF ? aall : (field == S57field.NATF ? nall : "US-ASCII");
                    str = new String(buffer, offset, i, charset);
                }
                catch (UnsupportedEncodingException e) {
                    Logging.error((Throwable)e);
                }
                offset += i + 1;
            } else {
                str = new String(buffer, offset, conv.asc);
                offset += conv.asc;
            }
            return str;
        }
        int f = Math.abs(conv.bin);
        if (f < 5) {
            long val = buffer[offset + --f];
            if (conv.bin > 0) {
                val &= 0xFFL;
            }
            while (f > 0) {
                val = (val << 8) + (long)(buffer[offset + --f] & 0xFF);
            }
            offset += Math.abs(conv.bin);
            if (subf == S57subf.AALL || subf == S57subf.NALL) {
                String charset = "";
                switch ((int)val) {
                    case 0: {
                        charset = "US-ASCII";
                        break;
                    }
                    case 1: {
                        charset = "ISO-8859-1";
                        break;
                    }
                    case 2: {
                        charset = "UTF-16LE";
                    }
                }
                if (subf == S57subf.NALL) {
                    nall = charset;
                } else {
                    aall = charset;
                }
            }
            return val;
        }
        if (f == 5) {
            long val = buffer[offset++] & 0xFF;
            --f;
            while (f > 0) {
                val = (val << 8) + (long)(buffer[offset + --f] & 0xFF);
            }
            offset += 4;
            return val;
        }
        long val = buffer[offset++] & 0xFF;
        val = (val << 8) + (long)(buffer[offset++] & 0xFF);
        f = 4;
        while (f > 0) {
            val = (val << 8) + (long)(buffer[offset + --f] & 0xFF);
        }
        offset += 4;
        f = 2;
        while (f > 0) {
            val = (val << 8) + (long)(buffer[offset + --f] & 0xFF);
        }
        offset += 2;
        return val;
    }

    public static byte[] encSubf(S57subf subf, Object val) {
        S57conv conv = convs.get((Object)subf);
        if (conv.bin == 0 || asc) {
            String sval = "";
            if (val instanceof String) {
                sval = (String)val;
            } else if (val instanceof Integer) {
                sval = ((Integer)val).toString();
            } else if (val instanceof Long) {
                sval = ((Long)val).toString();
            } else if (val instanceof Double) {
                sval = ((Double)val).toString();
            }
            index = sval.length();
            try {
                buffer = (sval + " ").getBytes("ISO-8859-1");
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            if (conv.asc == 0) {
                S57dat.buffer[S57dat.index] = 31;
            } else {
                buffer = Arrays.copyOf(buffer, conv.asc);
                while (index < buffer.length) {
                    S57dat.buffer[S57dat.index++] = 32;
                }
            }
        } else {
            long lval;
            int f = Math.abs(conv.bin);
            if (val instanceof String) {
                lval = Long.parseLong((String)val);
            } else if (val instanceof Double) {
                double dval = (Double)val;
                lval = (long)dval;
            } else {
                lval = val instanceof Integer ? (long)((Integer)val).intValue() : (Long)val;
            }
            buffer = new byte[f];
            for (int i = 0; i < f; ++i) {
                S57dat.buffer[i] = (byte)(lval & 0xFFL);
                lval >>= 8;
            }
        }
        return buffer;
    }

    public static byte[] encRecord(String i8rn, ArrayList<Fparams> fparams) {
        asc = true;
        return S57dat.encRecord(Integer.parseInt(i8rn), fparams);
    }

    public static byte[] encRecord(int i8rn, ArrayList<Fparams> fparams) {
        ArrayList<Index> index = new ArrayList<Index>();
        int offset = 3;
        int maxlen = 3;
        byte[] buf = S57dat.encSubf(S57subf.I8RN, i8rn);
        buf = Arrays.copyOf(buf, 3);
        buf[2] = 30;
        index.add(new Index("0001".getBytes(), 3, 0));
        for (Fparams sfparams : fparams) {
            int ip = 0;
            while (ip < sfparams.params.length) {
                for (S57subf subf : fields.get((Object)sfparams.field)) {
                    byte[] next = S57dat.encSubf(subf, sfparams.params[ip++]);
                    buf = Arrays.copyOf(buf, buf.length + next.length);
                    System.arraycopy(next, 0, buf, buf.length - next.length, next.length);
                }
            }
            buf = Arrays.copyOf(buf, buf.length + 1);
            buf[buf.length - 1] = 30;
            int flen = buf.length - offset;
            index.add(new Index(sfparams.field.toString().getBytes(StandardCharsets.UTF_8), flen, offset));
            maxlen = flen > maxlen ? flen : maxlen;
            offset += flen;
        }
        int mlen = String.valueOf(maxlen).length();
        String ffmt = "%0" + mlen + "d";
        int olen = String.valueOf(offset).length();
        String ofmt = "%0" + olen + "d";
        int ilen = 4 + mlen + olen;
        int isiz = ilen * index.size() + 1;
        byte[] ibuf = new byte[isiz];
        int i = 0;
        for (Index item : index) {
            byte[] digits;
            for (byte ch : item.field) {
                ibuf[i++] = ch;
            }
            for (byte ch : digits = String.format(ffmt, item.length).getBytes()) {
                ibuf[i++] = ch;
            }
            for (byte ch : digits = String.format(ofmt, item.offset).getBytes()) {
                ibuf[i++] = ch;
            }
        }
        ibuf[i] = 30;
        byte[] fbuf = Arrays.copyOf(leader, leader.length + ibuf.length + buf.length);
        System.arraycopy(ibuf, 0, fbuf, leader.length, ibuf.length);
        System.arraycopy(buf, 0, fbuf, leader.length + ibuf.length, buf.length);
        fbuf[20] = (byte)(mlen + 48);
        fbuf[21] = (byte)(olen + 48);
        System.arraycopy(String.format("%05d", fbuf.length).getBytes(), 0, fbuf, 0, 5);
        System.arraycopy(String.format("%05d", leader.length + ibuf.length).getBytes(), 0, fbuf, 12, 5);
        asc = false;
        return fbuf;
    }

    public static void S57geoms(S57map map) {
        for (ArrayList list : map.features.values()) {
            for (S57map.Feature feature : list) {
                switch (S57prims.get((Object)feature.type)) {
                    case N: {
                        break;
                    }
                    case P: {
                        if (feature.geom.prim == S57map.Pflag.POINT) break;
                        break;
                    }
                    case L: {
                        break;
                    }
                    case A: {
                        break;
                    }
                    case PA: {
                        break;
                    }
                    case PL: {
                        break;
                    }
                    case LA: {
                        if (feature.geom.prim != S57map.Pflag.POINT) break;
                        break;
                    }
                }
            }
        }
    }

    static {
        convs.put(S57subf.I8RN, new S57conv(5, 2));
        convs.put(S57subf.RCNM, new S57conv(2, 1));
        convs.put(S57subf.RCID, new S57conv(10, 4));
        convs.put(S57subf.EXPP, new S57conv(1, 1));
        convs.put(S57subf.INTU, new S57conv(1, 1));
        convs.put(S57subf.DSNM, new S57conv(0, 0));
        convs.put(S57subf.EDTN, new S57conv(0, 0));
        convs.put(S57subf.UPDN, new S57conv(0, 0));
        convs.put(S57subf.UADT, new S57conv(8, 0));
        convs.put(S57subf.ISDT, new S57conv(8, 0));
        convs.put(S57subf.STED, new S57conv(4, 0));
        convs.put(S57subf.PRSP, new S57conv(3, 1));
        convs.put(S57subf.PSDN, new S57conv(0, 0));
        convs.put(S57subf.PRED, new S57conv(0, 0));
        convs.put(S57subf.PROF, new S57conv(2, 1));
        convs.put(S57subf.AGEN, new S57conv(2, 2));
        convs.put(S57subf.COMT, new S57conv(0, 0));
        convs.put(S57subf.DSTR, new S57conv(2, 1));
        convs.put(S57subf.AALL, new S57conv(1, 1));
        convs.put(S57subf.NALL, new S57conv(1, 1));
        convs.put(S57subf.NOMR, new S57conv(0, 4));
        convs.put(S57subf.NOCR, new S57conv(0, 4));
        convs.put(S57subf.NOGR, new S57conv(0, 4));
        convs.put(S57subf.NOLR, new S57conv(0, 4));
        convs.put(S57subf.NOIN, new S57conv(0, 4));
        convs.put(S57subf.NOCN, new S57conv(0, 4));
        convs.put(S57subf.NOED, new S57conv(0, 4));
        convs.put(S57subf.NOFA, new S57conv(0, 4));
        convs.put(S57subf.HDAT, new S57conv(3, 1));
        convs.put(S57subf.VDAT, new S57conv(2, 1));
        convs.put(S57subf.SDAT, new S57conv(2, 1));
        convs.put(S57subf.CSCL, new S57conv(0, 4));
        convs.put(S57subf.DUNI, new S57conv(2, 1));
        convs.put(S57subf.HUNI, new S57conv(2, 1));
        convs.put(S57subf.PUNI, new S57conv(2, 1));
        convs.put(S57subf.COUN, new S57conv(2, 1));
        convs.put(S57subf.COMF, new S57conv(0, 4));
        convs.put(S57subf.SOMF, new S57conv(0, 4));
        convs.put(S57subf.PROJ, new S57conv(3, 1));
        convs.put(S57subf.PRP1, new S57conv(0, -4));
        convs.put(S57subf.PRP2, new S57conv(0, -4));
        convs.put(S57subf.PRP3, new S57conv(0, -4));
        convs.put(S57subf.PRP4, new S57conv(0, -4));
        convs.put(S57subf.FEAS, new S57conv(0, -4));
        convs.put(S57subf.FNOR, new S57conv(0, -4));
        convs.put(S57subf.FPMF, new S57conv(0, 4));
        convs.put(S57subf.RPID, new S57conv(1, 1));
        convs.put(S57subf.RYCO, new S57conv(0, -4));
        convs.put(S57subf.RXCO, new S57conv(0, -4));
        convs.put(S57subf.CURP, new S57conv(2, 1));
        convs.put(S57subf.RXVL, new S57conv(0, -4));
        convs.put(S57subf.RYVL, new S57conv(0, -4));
        convs.put(S57subf.PRCO, new S57conv(2, 2));
        convs.put(S57subf.ESDT, new S57conv(8, 0));
        convs.put(S57subf.LSDT, new S57conv(8, 0));
        convs.put(S57subf.DCRT, new S57conv(0, 0));
        convs.put(S57subf.CODT, new S57conv(8, 0));
        convs.put(S57subf.PACC, new S57conv(0, 4));
        convs.put(S57subf.HACC, new S57conv(0, 4));
        convs.put(S57subf.SACC, new S57conv(0, 4));
        convs.put(S57subf.FILE, new S57conv(0, 0));
        convs.put(S57subf.LFIL, new S57conv(0, 0));
        convs.put(S57subf.VOLM, new S57conv(0, 0));
        convs.put(S57subf.IMPL, new S57conv(3, 0));
        convs.put(S57subf.SLAT, new S57conv(0, 0));
        convs.put(S57subf.WLON, new S57conv(0, 0));
        convs.put(S57subf.NLAT, new S57conv(0, 0));
        convs.put(S57subf.ELON, new S57conv(0, 0));
        convs.put(S57subf.CRCS, new S57conv(0, 0));
        convs.put(S57subf.NAM1, new S57conv(12, 5));
        convs.put(S57subf.NAM2, new S57conv(12, 5));
        convs.put(S57subf.OORA, new S57conv(1, 1));
        convs.put(S57subf.OAAC, new S57conv(6, 0));
        convs.put(S57subf.OACO, new S57conv(5, 2));
        convs.put(S57subf.OALL, new S57conv(0, 0));
        convs.put(S57subf.OATY, new S57conv(1, 1));
        convs.put(S57subf.DEFN, new S57conv(0, 0));
        convs.put(S57subf.AUTH, new S57conv(2, 2));
        convs.put(S57subf.RFTP, new S57conv(2, 1));
        convs.put(S57subf.RFVL, new S57conv(0, 0));
        convs.put(S57subf.ATLB, new S57conv(5, 2));
        convs.put(S57subf.ATDO, new S57conv(1, 1));
        convs.put(S57subf.ADMU, new S57conv(0, 0));
        convs.put(S57subf.ADFT, new S57conv(0, 0));
        convs.put(S57subf.RAVA, new S57conv(1, 1));
        convs.put(S57subf.DVAL, new S57conv(0, 0));
        convs.put(S57subf.DVSD, new S57conv(0, 0));
        convs.put(S57subf.OBLB, new S57conv(5, 2));
        convs.put(S57subf.ASET, new S57conv(1, 1));
        convs.put(S57subf.PRIM, new S57conv(1, 1));
        convs.put(S57subf.GRUP, new S57conv(3, 1));
        convs.put(S57subf.OBJL, new S57conv(5, 2));
        convs.put(S57subf.RVER, new S57conv(3, 2));
        convs.put(S57subf.RUIN, new S57conv(1, 1));
        convs.put(S57subf.FIDN, new S57conv(10, 4));
        convs.put(S57subf.FIDS, new S57conv(5, 2));
        convs.put(S57subf.ATTL, new S57conv(5, 2));
        convs.put(S57subf.ATVL, new S57conv(0, 0));
        convs.put(S57subf.FFUI, new S57conv(1, 1));
        convs.put(S57subf.FFIX, new S57conv(0, 2));
        convs.put(S57subf.NFPT, new S57conv(0, 2));
        convs.put(S57subf.LNAM, new S57conv(17, 8));
        convs.put(S57subf.RIND, new S57conv(0, 1));
        convs.put(S57subf.FSUI, new S57conv(1, 1));
        convs.put(S57subf.FSIX, new S57conv(0, 2));
        convs.put(S57subf.NSPT, new S57conv(0, 2));
        convs.put(S57subf.NAME, new S57conv(12, 5));
        convs.put(S57subf.ORNT, new S57conv(1, 1));
        convs.put(S57subf.USAG, new S57conv(1, 1));
        convs.put(S57subf.MASK, new S57conv(1, 1));
        convs.put(S57subf.VPUI, new S57conv(1, 1));
        convs.put(S57subf.VPIX, new S57conv(0, 2));
        convs.put(S57subf.NVPT, new S57conv(0, 2));
        convs.put(S57subf.TOPI, new S57conv(1, 1));
        convs.put(S57subf.CCUI, new S57conv(1, 1));
        convs.put(S57subf.CCIX, new S57conv(0, 2));
        convs.put(S57subf.CCNC, new S57conv(0, 2));
        convs.put(S57subf.YCOO, new S57conv(0, -4));
        convs.put(S57subf.XCOO, new S57conv(0, -4));
        convs.put(S57subf.VE3D, new S57conv(0, -4));
        convs.put(S57subf.ATYP, new S57conv(1, 1));
        convs.put(S57subf.SURF, new S57conv(1, 1));
        convs.put(S57subf.ORDR, new S57conv(1, 1));
        convs.put(S57subf.RESO, new S57conv(0, 4));
        convs.put(S57subf.STPT, new S57conv(0, 0));
        convs.put(S57subf.CTPT, new S57conv(0, 0));
        convs.put(S57subf.ENPT, new S57conv(0, 0));
        convs.put(S57subf.CDPM, new S57conv(0, 0));
        convs.put(S57subf.CDPR, new S57conv(0, 0));
        S57i8ri = new ArrayList<S57subf>(Arrays.asList(S57subf.I8RN));
        S57dsid = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.EXPP, S57subf.INTU, S57subf.DSNM, S57subf.EDTN, S57subf.UPDN, S57subf.UADT, S57subf.ISDT, S57subf.STED, S57subf.PRSP, S57subf.PSDN, S57subf.PRED, S57subf.PROF, S57subf.AGEN, S57subf.COMT));
        S57dssi = new ArrayList<S57subf>(Arrays.asList(S57subf.DSTR, S57subf.AALL, S57subf.NALL, S57subf.NOMR, S57subf.NOCR, S57subf.NOGR, S57subf.NOLR, S57subf.NOIN, S57subf.NOCN, S57subf.NOED, S57subf.NOFA));
        S57dspm = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.HDAT, S57subf.VDAT, S57subf.SDAT, S57subf.CSCL, S57subf.DUNI, S57subf.HUNI, S57subf.PUNI, S57subf.COUN, S57subf.COMF, S57subf.SOMF, S57subf.COMT));
        S57dspr = new ArrayList<S57subf>(Arrays.asList(S57subf.PROJ, S57subf.PRP1, S57subf.PRP2, S57subf.PRP3, S57subf.PRP4, S57subf.FEAS, S57subf.FNOR, S57subf.FPMF, S57subf.COMT));
        S57dsrc = new ArrayList<S57subf>(Arrays.asList(S57subf.RPID, S57subf.RYCO, S57subf.RXCO, S57subf.CURP, S57subf.FPMF, S57subf.RXVL, S57subf.RYVL, S57subf.COMT));
        S57dsht = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.PRCO, S57subf.ESDT, S57subf.LSDT, S57subf.DCRT, S57subf.CODT, S57subf.COMT));
        S57dsac = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.PACC, S57subf.HACC, S57subf.SACC, S57subf.FPMF, S57subf.COMT));
        S57catd = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.FILE, S57subf.LFIL, S57subf.VOLM, S57subf.IMPL, S57subf.SLAT, S57subf.WLON, S57subf.NLAT, S57subf.ELON, S57subf.CRCS, S57subf.COMT));
        S57catx = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.NAM1, S57subf.NAM2, S57subf.COMT));
        S57dddf = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.OORA, S57subf.OAAC, S57subf.OACO, S57subf.OALL, S57subf.OATY, S57subf.DEFN, S57subf.AUTH, S57subf.COMT));
        S57dddr = new ArrayList<S57subf>(Arrays.asList(S57subf.RFTP, S57subf.RFVL));
        S57dddi = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.ATLB, S57subf.ATDO, S57subf.ADMU, S57subf.ADFT, S57subf.AUTH, S57subf.COMT));
        S57ddom = new ArrayList<S57subf>(Arrays.asList(S57subf.RAVA, S57subf.DVAL, S57subf.DVSD, S57subf.DEFN, S57subf.AUTH));
        S57ddrf = new ArrayList<S57subf>(Arrays.asList(S57subf.RFTP, S57subf.RFVL));
        S57ddsi = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.OBLB));
        S57ddsc = new ArrayList<S57subf>(Arrays.asList(S57subf.ATLB, S57subf.ASET, S57subf.AUTH));
        S57frid = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.PRIM, S57subf.GRUP, S57subf.OBJL, S57subf.RVER, S57subf.RUIN));
        S57foid = new ArrayList<S57subf>(Arrays.asList(S57subf.AGEN, S57subf.FIDN, S57subf.FIDS));
        S57lnam = new ArrayList<S57subf>(Arrays.asList(S57subf.LNAM));
        S57attf = new ArrayList<S57subf>(Arrays.asList(S57subf.ATTL, S57subf.ATVL));
        S57natf = new ArrayList<S57subf>(Arrays.asList(S57subf.ATTL, S57subf.ATVL));
        S57ffpc = new ArrayList<S57subf>(Arrays.asList(S57subf.FFUI, S57subf.FFIX, S57subf.NFPT));
        S57ffpt = new ArrayList<S57subf>(Arrays.asList(S57subf.LNAM, S57subf.RIND, S57subf.COMT));
        S57fspc = new ArrayList<S57subf>(Arrays.asList(S57subf.FSUI, S57subf.FSIX, S57subf.NSPT));
        S57fspt = new ArrayList<S57subf>(Arrays.asList(S57subf.NAME, S57subf.ORNT, S57subf.USAG, S57subf.MASK));
        S57vrid = new ArrayList<S57subf>(Arrays.asList(S57subf.RCNM, S57subf.RCID, S57subf.RVER, S57subf.RUIN));
        S57attv = new ArrayList<S57subf>(Arrays.asList(S57subf.ATTL, S57subf.ATVL));
        S57vrpc = new ArrayList<S57subf>(Arrays.asList(S57subf.VPUI, S57subf.VPIX, S57subf.NVPT));
        S57vrpt = new ArrayList<S57subf>(Arrays.asList(S57subf.NAME, S57subf.ORNT, S57subf.USAG, S57subf.TOPI, S57subf.MASK));
        S57sgcc = new ArrayList<S57subf>(Arrays.asList(S57subf.CCUI, S57subf.CCIX, S57subf.CCNC));
        S57sg2d = new ArrayList<S57subf>(Arrays.asList(S57subf.YCOO, S57subf.XCOO));
        S57sg3d = new ArrayList<S57subf>(Arrays.asList(S57subf.YCOO, S57subf.XCOO, S57subf.VE3D));
        S57arcc = new ArrayList<S57subf>(Arrays.asList(S57subf.ATYP, S57subf.SURF, S57subf.ORDR, S57subf.RESO, S57subf.FPMF));
        S57ar2d = new ArrayList<S57subf>(Arrays.asList(S57subf.STPT, S57subf.CTPT, S57subf.ENPT, S57subf.YCOO, S57subf.XCOO));
        S57el2d = new ArrayList<S57subf>(Arrays.asList(S57subf.STPT, S57subf.CTPT, S57subf.ENPT, S57subf.CDPM, S57subf.CDPR, S57subf.YCOO, S57subf.XCOO));
        S57ct2d = new ArrayList<S57subf>(Arrays.asList(S57subf.YCOO, S57subf.XCOO));
        fields = new EnumMap(S57field.class);
        fields.put(S57field.I8RI, S57i8ri);
        fields.put(S57field.DSID, S57dsid);
        fields.put(S57field.DSSI, S57dssi);
        fields.put(S57field.DSPM, S57dspm);
        fields.put(S57field.DSPR, S57dspr);
        fields.put(S57field.DSRC, S57dsrc);
        fields.put(S57field.DSHT, S57dsht);
        fields.put(S57field.DSAC, S57dsac);
        fields.put(S57field.CATD, S57catd);
        fields.put(S57field.CATX, S57catx);
        fields.put(S57field.DDDF, S57dddf);
        fields.put(S57field.DDDR, S57dddr);
        fields.put(S57field.DDDI, S57dddi);
        fields.put(S57field.DDOM, S57ddom);
        fields.put(S57field.DDRF, S57ddrf);
        fields.put(S57field.DDSI, S57ddsi);
        fields.put(S57field.DDSC, S57ddsc);
        fields.put(S57field.FRID, S57frid);
        fields.put(S57field.FOID, S57foid);
        fields.put(S57field.LNAM, S57lnam);
        fields.put(S57field.ATTF, S57attf);
        fields.put(S57field.NATF, S57natf);
        fields.put(S57field.FFPC, S57ffpc);
        fields.put(S57field.FFPT, S57ffpt);
        fields.put(S57field.FFPC, S57fspc);
        fields.put(S57field.FSPT, S57fspt);
        fields.put(S57field.VRID, S57vrid);
        fields.put(S57field.ATTV, S57attv);
        fields.put(S57field.VRPC, S57vrpc);
        fields.put(S57field.VRPT, S57vrpt);
        fields.put(S57field.SGCC, S57sgcc);
        fields.put(S57field.SG2D, S57sg2d);
        fields.put(S57field.SG3D, S57sg3d);
        fields.put(S57field.ARCC, S57arcc);
        fields.put(S57field.AR2D, S57ar2d);
        fields.put(S57field.EL2D, S57el2d);
        fields.put(S57field.CT2D, S57ct2d);
        leader = new byte[]{48, 48, 48, 48, 48, 32, 68, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 32, 32, 32, 48, 48, 48, 52};
        aall = "US-ASCII";
        nall = "US-ASCII";
        asc = false;
        S57prims = new EnumMap(S57obj.Obj.class);
        S57prims.put(S57obj.Obj.UNKOBJ, Prims.PLA);
        S57prims.put(S57obj.Obj.M_COVR, Prims.A);
        S57prims.put(S57obj.Obj.M_NSYS, Prims.A);
        S57prims.put(S57obj.Obj.AIRARE, Prims.PA);
        S57prims.put(S57obj.Obj.ACHBRT, Prims.PA);
        S57prims.put(S57obj.Obj.ACHARE, Prims.PA);
        S57prims.put(S57obj.Obj.BCNCAR, Prims.P);
        S57prims.put(S57obj.Obj.BCNISD, Prims.P);
        S57prims.put(S57obj.Obj.BCNLAT, Prims.P);
        S57prims.put(S57obj.Obj.BCNSAW, Prims.P);
        S57prims.put(S57obj.Obj.BCNSPP, Prims.P);
        S57prims.put(S57obj.Obj.BERTHS, Prims.PLA);
        S57prims.put(S57obj.Obj.BRIDGE, Prims.PLA);
        S57prims.put(S57obj.Obj.BUISGL, Prims.PA);
        S57prims.put(S57obj.Obj.BUAARE, Prims.PA);
        S57prims.put(S57obj.Obj.BOYCAR, Prims.P);
        S57prims.put(S57obj.Obj.BOYINB, Prims.P);
        S57prims.put(S57obj.Obj.BOYISD, Prims.P);
        S57prims.put(S57obj.Obj.BOYLAT, Prims.P);
        S57prims.put(S57obj.Obj.BOYSAW, Prims.P);
        S57prims.put(S57obj.Obj.BOYSPP, Prims.P);
        S57prims.put(S57obj.Obj.CBLARE, Prims.A);
        S57prims.put(S57obj.Obj.CBLOHD, Prims.L);
        S57prims.put(S57obj.Obj.CBLSUB, Prims.L);
        S57prims.put(S57obj.Obj.CANALS, Prims.A);
        S57prims.put(S57obj.Obj.CTSARE, Prims.PA);
        S57prims.put(S57obj.Obj.CAUSWY, Prims.LA);
        S57prims.put(S57obj.Obj.CTNARE, Prims.PA);
        S57prims.put(S57obj.Obj.CHKPNT, Prims.PA);
        S57prims.put(S57obj.Obj.CGUSTA, Prims.P);
        S57prims.put(S57obj.Obj.COALNE, Prims.L);
        S57prims.put(S57obj.Obj.CONZNE, Prims.A);
        S57prims.put(S57obj.Obj.COSARE, Prims.A);
        S57prims.put(S57obj.Obj.CTRPNT, Prims.P);
        S57prims.put(S57obj.Obj.CONVYR, Prims.LA);
        S57prims.put(S57obj.Obj.CRANES, Prims.PA);
        S57prims.put(S57obj.Obj.CURENT, Prims.P);
        S57prims.put(S57obj.Obj.CUSZNE, Prims.A);
        S57prims.put(S57obj.Obj.DAMCON, Prims.LA);
        S57prims.put(S57obj.Obj.DAYMAR, Prims.P);
        S57prims.put(S57obj.Obj.DWRTCL, Prims.L);
        S57prims.put(S57obj.Obj.DWRTPT, Prims.A);
        S57prims.put(S57obj.Obj.DEPARE, Prims.A);
        S57prims.put(S57obj.Obj.DEPCNT, Prims.L);
        S57prims.put(S57obj.Obj.DISMAR, Prims.P);
        S57prims.put(S57obj.Obj.DOCARE, Prims.A);
        S57prims.put(S57obj.Obj.DRGARE, Prims.A);
        S57prims.put(S57obj.Obj.DRYDOC, Prims.A);
        S57prims.put(S57obj.Obj.DMPGRD, Prims.PA);
        S57prims.put(S57obj.Obj.DYKCON, Prims.L);
        S57prims.put(S57obj.Obj.EXEZNE, Prims.A);
        S57prims.put(S57obj.Obj.FAIRWY, Prims.A);
        S57prims.put(S57obj.Obj.FNCLNE, Prims.L);
        S57prims.put(S57obj.Obj.FERYRT, Prims.LA);
        S57prims.put(S57obj.Obj.FSHZNE, Prims.A);
        S57prims.put(S57obj.Obj.FSHFAC, Prims.PLA);
        S57prims.put(S57obj.Obj.FSHGRD, Prims.A);
        S57prims.put(S57obj.Obj.FLODOC, Prims.A);
        S57prims.put(S57obj.Obj.FOGSIG, Prims.P);
        S57prims.put(S57obj.Obj.FORSTC, Prims.PLA);
        S57prims.put(S57obj.Obj.FRPARE, Prims.A);
        S57prims.put(S57obj.Obj.GATCON, Prims.PLA);
        S57prims.put(S57obj.Obj.GRIDRN, Prims.PA);
        S57prims.put(S57obj.Obj.HRBARE, Prims.A);
        S57prims.put(S57obj.Obj.HRBFAC, Prims.PA);
        S57prims.put(S57obj.Obj.HULKES, Prims.PA);
        S57prims.put(S57obj.Obj.ICEARE, Prims.A);
        S57prims.put(S57obj.Obj.ICNARE, Prims.PA);
        S57prims.put(S57obj.Obj.ISTZNE, Prims.A);
        S57prims.put(S57obj.Obj.LAKARE, Prims.A);
        S57prims.put(S57obj.Obj.LNDARE, Prims.PLA);
        S57prims.put(S57obj.Obj.LNDELV, Prims.PL);
        S57prims.put(S57obj.Obj.LNDRGN, Prims.PA);
        S57prims.put(S57obj.Obj.LNDMRK, Prims.PLA);
        S57prims.put(S57obj.Obj.LIGHTS, Prims.P);
        S57prims.put(S57obj.Obj.LITFLT, Prims.P);
        S57prims.put(S57obj.Obj.LITVES, Prims.P);
        S57prims.put(S57obj.Obj.LOCMAG, Prims.PLA);
        S57prims.put(S57obj.Obj.LOKBSN, Prims.A);
        S57prims.put(S57obj.Obj.LOGPON, Prims.PA);
        S57prims.put(S57obj.Obj.MAGVAR, Prims.PLA);
        S57prims.put(S57obj.Obj.MARCUL, Prims.PLA);
        S57prims.put(S57obj.Obj.MIPARE, Prims.PA);
        S57prims.put(S57obj.Obj.MORFAC, Prims.PLA);
        S57prims.put(S57obj.Obj.MPAARE, Prims.PA);
        S57prims.put(S57obj.Obj.NAVLNE, Prims.L);
        S57prims.put(S57obj.Obj.OBSTRN, Prims.PLA);
        S57prims.put(S57obj.Obj.OFSPLF, Prims.PA);
        S57prims.put(S57obj.Obj.OSPARE, Prims.A);
        S57prims.put(S57obj.Obj.OILBAR, Prims.L);
        S57prims.put(S57obj.Obj.PILPNT, Prims.P);
        S57prims.put(S57obj.Obj.PILBOP, Prims.PA);
        S57prims.put(S57obj.Obj.PIPARE, Prims.PA);
        S57prims.put(S57obj.Obj.PIPOHD, Prims.L);
        S57prims.put(S57obj.Obj.PIPSOL, Prims.PL);
        S57prims.put(S57obj.Obj.PONTON, Prims.LA);
        S57prims.put(S57obj.Obj.PRCARE, Prims.PA);
        S57prims.put(S57obj.Obj.PRDARE, Prims.PA);
        S57prims.put(S57obj.Obj.PYLONS, Prims.PA);
        S57prims.put(S57obj.Obj.RADLNE, Prims.L);
        S57prims.put(S57obj.Obj.RADRNG, Prims.A);
        S57prims.put(S57obj.Obj.RADRFL, Prims.P);
        S57prims.put(S57obj.Obj.RADSTA, Prims.P);
        S57prims.put(S57obj.Obj.RTPBCN, Prims.P);
        S57prims.put(S57obj.Obj.RDOCAL, Prims.PL);
        S57prims.put(S57obj.Obj.RDOSTA, Prims.P);
        S57prims.put(S57obj.Obj.RAILWY, Prims.L);
        S57prims.put(S57obj.Obj.RAPIDS, Prims.PLA);
        S57prims.put(S57obj.Obj.RCRTCL, Prims.L);
        S57prims.put(S57obj.Obj.RECTRC, Prims.LA);
        S57prims.put(S57obj.Obj.RCTLPT, Prims.PA);
        S57prims.put(S57obj.Obj.RSCSTA, Prims.P);
        S57prims.put(S57obj.Obj.RESARE, Prims.A);
        S57prims.put(S57obj.Obj.RETRFL, Prims.P);
        S57prims.put(S57obj.Obj.RIVERS, Prims.LA);
        S57prims.put(S57obj.Obj.ROADWY, Prims.PLA);
        S57prims.put(S57obj.Obj.RUNWAY, Prims.PLA);
        S57prims.put(S57obj.Obj.SNDWAV, Prims.PLA);
        S57prims.put(S57obj.Obj.SEAARE, Prims.PA);
        S57prims.put(S57obj.Obj.SPLARE, Prims.PA);
        S57prims.put(S57obj.Obj.SBDARE, Prims.PLA);
        S57prims.put(S57obj.Obj.SLCONS, Prims.PLA);
        S57prims.put(S57obj.Obj.SISTAT, Prims.P);
        S57prims.put(S57obj.Obj.SISTAW, Prims.P);
        S57prims.put(S57obj.Obj.SILTNK, Prims.PA);
        S57prims.put(S57obj.Obj.SLOTOP, Prims.L);
        S57prims.put(S57obj.Obj.SLOGRD, Prims.PA);
        S57prims.put(S57obj.Obj.SMCFAC, Prims.PA);
        S57prims.put(S57obj.Obj.SOUNDG, Prims.P);
        S57prims.put(S57obj.Obj.SPRING, Prims.P);
        S57prims.put(S57obj.Obj.STSLNE, Prims.L);
        S57prims.put(S57obj.Obj.SUBTLN, Prims.A);
        S57prims.put(S57obj.Obj.SWPARE, Prims.A);
        S57prims.put(S57obj.Obj.TESARE, Prims.A);
        S57prims.put(S57obj.Obj.TS_PRH, Prims.PA);
        S57prims.put(S57obj.Obj.TS_PNH, Prims.PA);
        S57prims.put(S57obj.Obj.TS_PAD, Prims.PA);
        S57prims.put(S57obj.Obj.TS_TIS, Prims.PA);
        S57prims.put(S57obj.Obj.T_HMON, Prims.PA);
        S57prims.put(S57obj.Obj.T_NHMN, Prims.PA);
        S57prims.put(S57obj.Obj.T_TIMS, Prims.PA);
        S57prims.put(S57obj.Obj.TIDEWY, Prims.LA);
        S57prims.put(S57obj.Obj.TOPMAR, Prims.P);
        S57prims.put(S57obj.Obj.TSELNE, Prims.LA);
        S57prims.put(S57obj.Obj.TSSBND, Prims.L);
        S57prims.put(S57obj.Obj.TSSCRS, Prims.A);
        S57prims.put(S57obj.Obj.TSSLPT, Prims.A);
        S57prims.put(S57obj.Obj.TSSRON, Prims.A);
        S57prims.put(S57obj.Obj.TSEZNE, Prims.A);
        S57prims.put(S57obj.Obj.TUNNEL, Prims.LA);
        S57prims.put(S57obj.Obj.TWRTPT, Prims.A);
        S57prims.put(S57obj.Obj.UWTROC, Prims.P);
        S57prims.put(S57obj.Obj.UNSARE, Prims.A);
        S57prims.put(S57obj.Obj.VEGATN, Prims.PLA);
        S57prims.put(S57obj.Obj.WATTUR, Prims.PLA);
        S57prims.put(S57obj.Obj.WATFAL, Prims.PL);
        S57prims.put(S57obj.Obj.WEDKLP, Prims.PA);
        S57prims.put(S57obj.Obj.WRECKS, Prims.PA);
        S57prims.put(S57obj.Obj.TS_FEB, Prims.PA);
        S57prims.put(S57obj.Obj.NOTMRK, Prims.P);
        S57prims.put(S57obj.Obj.WTWAXS, Prims.L);
        S57prims.put(S57obj.Obj.WTWPRF, Prims.L);
        S57prims.put(S57obj.Obj.BUNSTA, Prims.PA);
        S57prims.put(S57obj.Obj.COMARE, Prims.A);
        S57prims.put(S57obj.Obj.HRBBSN, Prims.A);
        S57prims.put(S57obj.Obj.LKBSPT, Prims.A);
        S57prims.put(S57obj.Obj.PRTARE, Prims.A);
        S57prims.put(S57obj.Obj.REFDMP, Prims.P);
        S57prims.put(S57obj.Obj.TERMNL, Prims.PA);
        S57prims.put(S57obj.Obj.TRNBSN, Prims.PA);
        S57prims.put(S57obj.Obj.WTWARE, Prims.A);
        S57prims.put(S57obj.Obj.WTWGAG, Prims.PA);
        S57prims.put(S57obj.Obj.TISDGE, Prims.N);
        S57prims.put(S57obj.Obj.VEHTRF, Prims.PA);
        S57prims.put(S57obj.Obj.EXCNST, Prims.PA);
        S57prims.put(S57obj.Obj.LG_SDM, Prims.A);
        S57prims.put(S57obj.Obj.LG_VSP, Prims.A);
        S57prims.put(S57obj.Obj.LITMAJ, Prims.P);
        S57prims.put(S57obj.Obj.LITMIN, Prims.P);
    }

    static enum Prims {
        N,
        P,
        L,
        A,
        PA,
        PL,
        LA,
        PLA;

    }

    public static class Fparams {
        public S57field field;
        public Object[] params;

        public Fparams(S57field f, Object[] p) {
            this.field = f;
            this.params = p;
        }
    }

    static class Index {
        byte[] field;
        int length;
        int offset;

        Index(byte[] id, int l, int o) {
            this.field = id;
            this.length = l;
            this.offset = o;
        }
    }

    public static enum S57field {
        I8RI,
        DSID,
        DSSI,
        DSPM,
        DSPR,
        DSRC,
        DSHT,
        DSAC,
        CATD,
        CATX,
        DDDF,
        DDDR,
        DDDI,
        DDOM,
        DDRF,
        DDSI,
        DDSC,
        FRID,
        FOID,
        LNAM,
        ATTF,
        NATF,
        FFPC,
        FFPT,
        FSPC,
        FSPT,
        VRID,
        ATTV,
        VRPC,
        VRPT,
        SGCC,
        SG2D,
        SG3D,
        ARCC,
        AR2D,
        EL2D,
        CT2D;

    }

    public static enum S57subf {
        I8RN,
        RCNM,
        RCID,
        EXPP,
        INTU,
        DSNM,
        EDTN,
        UPDN,
        UADT,
        ISDT,
        STED,
        PRSP,
        PSDN,
        PRED,
        PROF,
        AGEN,
        COMT,
        DSTR,
        AALL,
        NALL,
        NOMR,
        NOCR,
        NOGR,
        NOLR,
        NOIN,
        NOCN,
        NOED,
        NOFA,
        HDAT,
        VDAT,
        SDAT,
        CSCL,
        DUNI,
        HUNI,
        PUNI,
        COUN,
        COMF,
        SOMF,
        PROJ,
        PRP1,
        PRP2,
        PRP3,
        PRP4,
        FEAS,
        FNOR,
        FPMF,
        RPID,
        RYCO,
        RXCO,
        CURP,
        RXVL,
        RYVL,
        PRCO,
        ESDT,
        LSDT,
        DCRT,
        CODT,
        PACC,
        HACC,
        SACC,
        FILE,
        LFIL,
        VOLM,
        IMPL,
        SLAT,
        WLON,
        NLAT,
        ELON,
        CRCS,
        NAM1,
        NAM2,
        OORA,
        OAAC,
        OACO,
        OALL,
        OATY,
        DEFN,
        AUTH,
        RFTP,
        RFVL,
        ATLB,
        ATDO,
        ADMU,
        ADFT,
        RAVA,
        DVAL,
        DVSD,
        OBLB,
        ASET,
        PRIM,
        GRUP,
        OBJL,
        RVER,
        RUIN,
        FIDN,
        FIDS,
        ATTL,
        ATVL,
        FFUI,
        FFIX,
        NFPT,
        LNAM,
        RIND,
        FSUI,
        FSIX,
        NSPT,
        NAME,
        ORNT,
        USAG,
        MASK,
        VPUI,
        VPIX,
        NVPT,
        TOPI,
        CCUI,
        CCIX,
        CCNC,
        YCOO,
        XCOO,
        VE3D,
        ATYP,
        SURF,
        ORDR,
        RESO,
        STPT,
        CTPT,
        ENPT,
        CDPM,
        CDPR;

    }

    public static class S57conv {
        int asc;
        int bin;

        S57conv(int a, int b) {
            this.asc = a;
            this.bin = b;
        }
    }
}

