/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.NationalHandlers;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlHandler;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UserCancelException;

public class GmlReader
extends GeographicReader {
    public static final String GML_FEATURE_MEMBER = "featureMember";
    public static final String GML_LINE_STRING = "LineString";
    public static final String GML_LINEAR_RING = "LinearRing";
    public static final String GML_POINT = "Point";
    public static final String GML_SURFACE = "Surface";
    public static final String GML_SRS_NAME = "srsName";
    public static final String GML_SRS_DIMENSION = "srsDimension";
    public static final String GML_POS_LIST = "posList";
    public static final String GML_COORDINATES = "coordinates";
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final GmlHandler gmlHandler;
    private XMLStreamReader parser;
    private int dim;
    private final Map<String, CrsData> crsDataMap = new HashMap<String, CrsData>();

    public GmlReader(XMLStreamReader parser, GmlHandler handler) {
        super(handler, NationalHandlers.DEFAULT_GML_HANDLERS);
        this.parser = parser;
        this.gmlHandler = handler;
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException, XMLStreamException {
        UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)in, (String)"UTF-8");
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader((Reader)ir);
        try {
            return new GmlReader(parser, handler != null ? handler.getGmlHandler() : null).parseDoc(instance);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private boolean isElement(String element) {
        return this.parser.getLocalName().matches("(gml:)?" + element);
    }

    private DataSet parseDoc(ProgressMonitor instance) throws XMLStreamException, GeoCrsException, FactoryException, GeoMathTransformException, MismatchedDimensionException, TransformException {
        Object parent;
        Object object = parent = instance != null ? instance.getWindowParent() : MainApplication.getMainFrame();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event != 1 || !this.isElement(GML_FEATURE_MEMBER)) continue;
            try {
                this.parseFeatureMember((Component)parent);
            }
            catch (UserCancelException e) {
                return this.ds;
            }
        }
        return this.ds;
    }

    private void findCRS(String srs) throws NoSuchAuthorityCodeException, FactoryException {
        Logging.info((String)("Finding CRS for " + srs));
        if (this.gmlHandler != null) {
            this.crs = this.gmlHandler.getCrsFor(srs);
        } else {
            for (GmlHandler h : NationalHandlers.DEFAULT_GML_HANDLERS) {
                this.crs = h.getCrsFor(srs);
                if (this.crs == null) continue;
                return;
            }
        }
    }

    private void parseSrs(Component parent) throws GeoCrsException, FactoryException, UserCancelException, GeoMathTransformException {
        String srs = this.parser.getAttributeValue(null, GML_SRS_NAME);
        String sdim = this.parser.getAttributeValue(null, GML_SRS_DIMENSION);
        this.dim = sdim != null ? Integer.parseInt(sdim) : 2;
        CrsData crsData = this.crsDataMap.get(srs);
        if (crsData == null) {
            try {
                this.findCRS(srs);
            }
            catch (NoSuchAuthorityCodeException e) {
                e.printStackTrace();
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
            if (this.crs == null) {
                throw new GeoCrsException("Unable to detect CRS for srs '" + srs + "' !");
            }
            this.findMathTransform(parent, false);
            this.crsDataMap.put(srs, new CrsData(this.crs, this.transform, this.dim));
        } else {
            this.crs = crsData.crs;
            this.transform = crsData.transform;
            this.dim = crsData.dim;
        }
    }

    private void parseFeatureMember(Component parent) throws XMLStreamException, GeoCrsException, FactoryException, UserCancelException, GeoMathTransformException, MismatchedDimensionException, TransformException {
        Way way = null;
        Node node = null;
        HashMap<String, StringBuilder> tags = new HashMap<String, StringBuilder>();
        Way prim = null;
        String key = null;
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                String[] tab;
                if (this.isElement(GML_LINE_STRING)) {
                    prim = way = this.createWay();
                    this.parseSrs(parent);
                    continue;
                }
                if (this.isElement(GML_LINEAR_RING)) {
                    prim = way = this.createWay();
                    continue;
                }
                if (this.isElement(GML_POINT)) {
                    this.parseSrs(parent);
                    continue;
                }
                if (this.isElement(GML_SURFACE)) {
                    this.parseSrs(parent);
                    continue;
                }
                if (this.isElement(GML_POS_LIST)) {
                    tab = this.parser.getElementText().split(" ");
                    for (int i = 0; i < tab.length; i += this.dim) {
                        Point p = this.geometryFactory.createPoint(new Coordinate(Double.valueOf(tab[i]).doubleValue(), Double.valueOf(tab[i + 1]).doubleValue()));
                        node = this.createOrGetNode(p, this.dim > 2 && !tab[i + 2].equals("0") ? tab[i + 2] : null);
                        if (way != null) {
                            way.addNode(node);
                            continue;
                        }
                        prim = node;
                    }
                    continue;
                }
                if (this.isElement(GML_COORDINATES)) {
                    tab = this.parser.getElementText().trim().split(",");
                    Point p = this.geometryFactory.createPoint(new Coordinate(Double.valueOf(tab[0]).doubleValue(), Double.valueOf(tab[1]).doubleValue()));
                    node = this.createOrGetNode(p);
                    if (way != null) continue;
                    prim = node;
                    continue;
                }
                key = this.parser.getLocalName();
                if (!key.startsWith("ogr:")) continue;
                key = key.substring("ogr:".length());
                continue;
            }
            if (event == 2) {
                if (!this.isElement(GML_FEATURE_MEMBER)) continue;
                break;
            }
            if (event != 4 || key == null) continue;
            StringBuilder sb = (StringBuilder)tags.get(key);
            if (sb == null) {
                sb = new StringBuilder();
                tags.put(key, sb);
            }
            sb.append(this.parser.getTextCharacters(), this.parser.getTextStart(), this.parser.getTextLength());
        }
        if (prim != null) {
            for (String k : tags.keySet()) {
                prim.put(k, ((StringBuilder)tags.get(k)).toString());
            }
        }
    }

    private final class CrsData {
        public CoordinateReferenceSystem crs;
        public MathTransform transform;
        public int dim;

        CrsData(CoordinateReferenceSystem crs, MathTransform transform, int dim) {
            this.crs = crs;
            this.transform = transform;
            this.dim = dim;
        }
    }
}

