/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.gpx.ElevationWayPointKind;
import org.openstreetmap.josm.plugins.elevation.gui.DefaultElevationProfileRenderer;
import org.openstreetmap.josm.plugins.elevation.gui.IElevationProfileRenderer;
import org.openstreetmap.josm.plugins.elevation.gui.IElevationProfileSelectionListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ElevationProfileLayer
extends Layer
implements IElevationProfileSelectionListener {
    private static final double Level_Factor = 100.0;
    private IElevationProfile profile;
    private final IElevationProfileRenderer renderer = new DefaultElevationProfileRenderer();
    private WayPoint selWayPoint = null;

    public ElevationProfileLayer(String name) {
        super(name);
    }

    public IElevationProfile getProfile() {
        return this.profile;
    }

    public void setProfile(IElevationProfile profile) {
        if (this.profile != profile) {
            this.profile = profile;
            this.invalidate();
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"elevation");
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        if (this.profile != null) {
            return I18n.tr((String)"Elevation profile for track ''{0}''.", (Object[])new Object[]{this.profile.getName()});
        }
        return I18n.tr((String)"Elevation profile", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        WayPoint lastWpt = null;
        this.renderer.beginRendering();
        if (this.profile != null) {
            Font oldFont = g.getFont();
            Font lFont = g.getFont().deriveFont(9.0f);
            g.setFont(lFont);
            try {
                for (WayPoint wpt : this.profile.getWayPoints()) {
                    if (lastWpt != null) {
                        ElevationWayPointKind kind = this.classifyWayPoint(lastWpt, wpt);
                        this.renderer.renderLine(g, this.profile, mv, lastWpt, wpt, kind);
                        this.renderer.renderWayPoint(g, this.profile, mv, wpt, kind);
                    }
                    lastWpt = wpt;
                }
                this.renderer.renderWayPoint(g, this.profile, mv, this.profile.getStartWayPoint(), ElevationWayPointKind.StartPoint);
                this.renderer.renderWayPoint(g, this.profile, mv, this.profile.getEndWayPoint(), ElevationWayPointKind.EndPoint);
                this.renderer.renderWayPoint(g, this.profile, mv, this.profile.getMaxWayPoint(), ElevationWayPointKind.MaxElevation);
                this.renderer.renderWayPoint(g, this.profile, mv, this.profile.getMinWayPoint(), ElevationWayPointKind.MinElevation);
                if (this.selWayPoint != null) {
                    this.renderer.renderWayPoint(g, this.profile, mv, this.selWayPoint, ElevationWayPointKind.Highlighted);
                }
            }
            finally {
                g.setFont(oldFont);
            }
        }
        this.renderer.finishRendering();
    }

    private ElevationWayPointKind classifyWayPoint(WayPoint lastWpt, WayPoint actWpt) {
        int actEle = (int)ElevationHelper.getElevation(actWpt);
        int lastEle = (int)ElevationHelper.getElevation(lastWpt);
        int actLevel = (int)((double)actEle / 100.0);
        int lastLevel = (int)((double)lastEle / 100.0);
        double slope = Math.abs(ElevationHelper.computeSlope(lastWpt.getCoor(), actWpt.getCoor()));
        ElevationWayPointKind kind = ElevationWayPointKind.Plain;
        if (actLevel != lastLevel && Math.abs(actLevel - lastLevel) == 1) {
            kind = actLevel > lastLevel ? ElevationWayPointKind.ElevationLevelGain : ElevationWayPointKind.ElevationLevelLoss;
        } else if (actEle > lastEle) {
            if (slope > 2.0) {
                kind = ElevationWayPointKind.ElevationGainLow;
            }
            if (slope > 15.0) {
                kind = ElevationWayPointKind.ElevationGainHigh;
            }
        } else {
            if (slope > 2.0) {
                kind = ElevationWayPointKind.ElevationLossLow;
            }
            if (slope > 15.0) {
                kind = ElevationWayPointKind.ElevationLossHigh;
            }
        }
        return kind;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    @Override
    public void selectedWayPointChanged(WayPoint newWayPoint) {
        if (this.selWayPoint != newWayPoint) {
            this.selWayPoint = newWayPoint;
            this.invalidate();
        }
    }
}

