/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxWayPoint;

public class EditGpxTrackSegment {
    private final List<EditGpxWayPoint> wayPoints = new ArrayList<EditGpxWayPoint>();
    private boolean deleted;

    public EditGpxTrackSegment(GpxTrackSegment segment) {
        for (WayPoint wayPoint : segment.getWayPoints()) {
            this.wayPoints.add(new EditGpxWayPoint(wayPoint));
        }
    }

    public List<EditGpxWayPoint> getWayPoints() {
        return this.wayPoints;
    }

    public List<WayPoint> getNonDeletedWaypoints() {
        ArrayList<WayPoint> result = new ArrayList<WayPoint>();
        for (EditGpxWayPoint wp : this.wayPoints) {
            if (wp.isDeleted()) continue;
            result.add(wp.createWayPoint());
        }
        return result;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public double minNonDeletedTime() {
        return Collections.min(this.getNonDeletedWaypoints()).getTime();
    }
}

