/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.gml.SubHandler;
import org.geotools.gml.SubHandlerBox;
import org.geotools.gml.SubHandlerLineString;
import org.geotools.gml.SubHandlerLinearRing;
import org.geotools.gml.SubHandlerMulti;
import org.geotools.gml.SubHandlerPoint;
import org.geotools.gml.SubHandlerPolygon;
import org.geotools.util.logging.Logging;

public class SubHandlerFactory {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.gml");
    private static final Collection BASE_GEOMETRY_TYPES = new Vector<String>(Arrays.asList("MultiPoint", "MultiLineString", "MultiPolygon"));

    public SubHandlerFactory() {
        LOGGER.entering("SubHandlerFactory", "new");
        LOGGER.exiting("SubHandlerFactory", "new");
    }

    public SubHandler create(String type) {
        LOGGER.entering("SubHandlerFactory", "create", type);
        SubHandler returnValue = null;
        returnValue = type.equals("Point") ? new SubHandlerPoint() : (type.equals("LineString") ? new SubHandlerLineString() : (type.equals("LinearRing") ? new SubHandlerLinearRing() : (type.equals("Polygon") ? new SubHandlerPolygon() : (type.equals("Box") ? new SubHandlerBox() : (BASE_GEOMETRY_TYPES.contains(type) ? new SubHandlerMulti() : null)))));
        LOGGER.exiting("SubHandlerFactory", "create", returnValue);
        return returnValue;
    }
}

