/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.opengis.feature.type.GeometryDescriptor;

public class JTSUtilities {
    static final CGAlgorithms cga = new CGAlgorithms();

    private JTSUtilities() {
    }

    public static final double[] zMinMax(Coordinate[] cs) {
        double[] result = new double[]{Double.NaN, Double.NaN};
        JTSUtilities.zMinMax((CoordinateSequence)new CoordinateArraySequence(cs), result);
        return result;
    }

    public static final void zMinMax(CoordinateSequence cs, double[] target) {
        if (cs.getDimension() < 3) {
            return;
        }
        boolean validZFound = false;
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        int size = cs.size();
        for (int t = size - 1; t >= 0; --t) {
            double z = cs.getOrdinate(t, 2);
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        if (!Double.isNaN(zmin)) {
            target[0] = zmin;
        }
        if (!Double.isNaN(zmax)) {
            target[1] = zmax;
        }
    }

    public static final ShapeType findBestGeometryType(Geometry geom) {
        ShapeType type = ShapeType.UNDEFINED;
        if (geom instanceof Point) {
            type = ShapeType.POINT;
        } else if (geom instanceof MultiPoint) {
            type = ShapeType.MULTIPOINT;
        } else if (geom instanceof Polygon) {
            type = ShapeType.POLYGON;
        } else if (geom instanceof MultiPolygon) {
            type = ShapeType.POLYGON;
        } else if (geom instanceof LineString) {
            type = ShapeType.ARC;
        } else if (geom instanceof MultiLineString) {
            type = ShapeType.ARC;
        }
        return type;
    }

    public static final Class findBestGeometryClass(ShapeType type) {
        Class<Geometry> best;
        if (type == null || type == ShapeType.NULL) {
            best = Geometry.class;
        } else if (type.isLineType()) {
            best = MultiLineString.class;
        } else if (type.isMultiPointType()) {
            best = MultiPoint.class;
        } else if (type.isPointType()) {
            best = Point.class;
        } else if (type.isPolygonType()) {
            best = MultiPolygon.class;
        } else {
            throw new RuntimeException("Unknown ShapeType->GeometryClass : " + type);
        }
        return best;
    }

    public static final LinearRing reverseRing(LinearRing lr) {
        GeometryFactory gf = lr.getFactory();
        CoordinateSequenceFactory csf = gf.getCoordinateSequenceFactory();
        CoordinateSequence csOrig = lr.getCoordinateSequence();
        int numPoints = csOrig.size();
        int dimensions = csOrig.getDimension();
        CoordinateSequence csNew = JTS.createCS(csf, numPoints, dimensions);
        for (int i = 0; i < numPoints; ++i) {
            for (int j = 0; j < dimensions; ++j) {
                csNew.setOrdinate(numPoints - 1 - i, j, csOrig.getOrdinate(i, j));
            }
        }
        return gf.createLinearRing(csNew);
    }

    public static final Polygon makeGoodShapePolygon(Polygon p) {
        GeometryFactory factory = p.getFactory();
        LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
        Coordinate[] coords = p.getExteriorRing().getCoordinates();
        LinearRing outer = CGAlgorithms.isCCW((Coordinate[])coords) ? JTSUtilities.reverseRing((LinearRing)p.getExteriorRing()) : (LinearRing)p.getExteriorRing();
        int tt = p.getNumInteriorRing();
        for (int t = 0; t < tt; ++t) {
            coords = p.getInteriorRingN(t).getCoordinates();
            holes[t] = !CGAlgorithms.isCCW((Coordinate[])coords) ? JTSUtilities.reverseRing((LinearRing)p.getInteriorRingN(t)) : (LinearRing)p.getInteriorRingN(t);
        }
        return factory.createPolygon(outer, holes);
    }

    public static final MultiPolygon makeGoodShapeMultiPolygon(MultiPolygon mp) {
        Polygon[] ps = new Polygon[mp.getNumGeometries()];
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            ps[t] = JTSUtilities.makeGoodShapePolygon((Polygon)mp.getGeometryN(t));
        }
        MultiPolygon result = mp.getFactory().createMultiPolygon(ps);
        return result;
    }

    public static final int guessCoorinateDims(Coordinate[] cs) {
        int dims = 2;
        for (int t = cs.length - 1; t >= 0; --t) {
            if (Double.isNaN(cs[t].z)) continue;
            dims = 4;
            break;
        }
        return dims;
    }

    public static Geometry convertToCollection(Geometry geom, ShapeType type) {
        Object retVal = null;
        if (geom == null) {
            return null;
        }
        GeometryFactory factory = geom.getFactory();
        if (type.isPointType()) {
            if (geom instanceof Point) {
                retVal = geom;
            } else {
                Point[] pNull = null;
                retVal = factory.createMultiPoint(pNull);
            }
        } else if (type.isLineType()) {
            retVal = geom instanceof LineString ? factory.createMultiLineString(new LineString[]{(LineString)geom}) : (geom instanceof MultiLineString ? geom : factory.createMultiLineString(null));
        } else if (type.isPolygonType()) {
            if (geom instanceof Polygon) {
                Polygon p = JTSUtilities.makeGoodShapePolygon((Polygon)geom);
                retVal = factory.createMultiPolygon(new Polygon[]{p});
            } else {
                retVal = geom instanceof MultiPolygon ? JTSUtilities.makeGoodShapeMultiPolygon((MultiPolygon)geom) : factory.createMultiPolygon(null);
            }
        } else if (type.isMultiPointType()) {
            if (geom instanceof Point) {
                retVal = factory.createMultiPoint(new Point[]{(Point)geom});
            } else if (geom instanceof MultiPoint) {
                retVal = geom;
            } else {
                Point[] pNull = null;
                retVal = factory.createMultiPoint(pNull);
            }
        } else {
            throw new RuntimeException("Could not convert " + geom.getClass() + " to " + type);
        }
        return retVal;
    }

    public static final ShapeType getShapeType(Geometry geom, int shapeFileDimentions) throws ShapefileException {
        ShapeType type;
        block23: {
            block25: {
                block24: {
                    block22: {
                        type = null;
                        if (!(geom instanceof Point)) break block22;
                        switch (shapeFileDimentions) {
                            case 2: {
                                type = ShapeType.POINT;
                                break block23;
                            }
                            case 3: {
                                type = ShapeType.POINTM;
                                break block23;
                            }
                            case 4: {
                                type = ShapeType.POINTZ;
                                break block23;
                            }
                            default: {
                                throw new ShapefileException("Too many dimensions for shapefile : " + shapeFileDimentions);
                            }
                        }
                    }
                    if (!(geom instanceof MultiPoint)) break block24;
                    switch (shapeFileDimentions) {
                        case 2: {
                            type = ShapeType.MULTIPOINT;
                            break block23;
                        }
                        case 3: {
                            type = ShapeType.MULTIPOINTM;
                            break block23;
                        }
                        case 4: {
                            type = ShapeType.MULTIPOINTZ;
                            break block23;
                        }
                        default: {
                            throw new ShapefileException("Too many dimensions for shapefile : " + shapeFileDimentions);
                        }
                    }
                }
                if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon)) break block25;
                switch (shapeFileDimentions) {
                    case 2: {
                        type = ShapeType.POLYGON;
                        break block23;
                    }
                    case 3: {
                        type = ShapeType.POLYGONM;
                        break block23;
                    }
                    case 4: {
                        type = ShapeType.POLYGONZ;
                        break block23;
                    }
                    default: {
                        throw new ShapefileException("Too many dimensions for shapefile : " + shapeFileDimentions);
                    }
                }
            }
            if (geom instanceof LineString || geom instanceof MultiLineString) {
                switch (shapeFileDimentions) {
                    case 2: {
                        type = ShapeType.ARC;
                        break;
                    }
                    case 3: {
                        type = ShapeType.ARCM;
                        break;
                    }
                    case 4: {
                        type = ShapeType.ARCZ;
                        break;
                    }
                    default: {
                        throw new ShapefileException("Too many dimensions for shapefile : " + shapeFileDimentions);
                    }
                }
            }
        }
        if (type == null) {
            throw new ShapefileException("Cannot handle geometry type : " + (geom == null ? "null" : geom.getClass().getName()));
        }
        return type;
    }

    public static final ShapeType getShapeType(Class featureClass) throws ShapefileException {
        ShapeType type = null;
        if (Point.class.equals((Object)featureClass)) {
            type = ShapeType.POINT;
        } else if (MultiPoint.class.equals((Object)featureClass)) {
            type = ShapeType.MULTIPOINT;
        } else if (Polygon.class.equals((Object)featureClass) || MultiPolygon.class.equals((Object)featureClass)) {
            type = ShapeType.POLYGON;
        } else if (LineString.class.equals((Object)featureClass) || MultiLineString.class.equals((Object)featureClass)) {
            type = ShapeType.ARC;
        }
        if (type == null) {
            throw new ShapefileException("Cannot handle geometry class : " + (featureClass == null ? "null" : featureClass.getName()));
        }
        return type;
    }

    public static final ShapeType getShapeType(GeometryDescriptor gd) throws ShapefileException {
        Class<?> featureClass = gd.getType().getBinding();
        Integer dimension = (Integer)gd.getUserData().get(Hints.COORDINATE_DIMENSION);
        ShapeType type = null;
        if (Point.class.equals(featureClass)) {
            type = dimension != null && dimension == 3 ? ShapeType.POINTZ : ShapeType.POINT;
        } else if (MultiPoint.class.equals(featureClass)) {
            type = dimension != null && dimension == 3 ? ShapeType.MULTIPOINTZ : ShapeType.MULTIPOINT;
        } else if (Polygon.class.equals(featureClass) || MultiPolygon.class.equals(featureClass)) {
            type = dimension != null && dimension == 3 ? ShapeType.POLYGON : ShapeType.POLYGONZ;
        } else if (LineString.class.equals(featureClass) || MultiLineString.class.equals(featureClass)) {
            type = dimension != null && dimension == 3 ? ShapeType.ARC : ShapeType.ARCZ;
        }
        if (type == null) {
            throw new ShapefileException("Cannot handle geometry class : " + (featureClass == null ? "null" : featureClass.getName()));
        }
        return type;
    }
}

