/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import it.geosolutions.rendered.viewer.ZoomableImageDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ImageViewer
extends JPanel {
    private ZoomableImageDisplay display;
    private ImageViewer relatedViewer;
    private JLabel status;
    private RandomIter pixelIter;
    private int[] ipixel;
    private double[] dpixel;
    private StringBuffer sb = new StringBuffer();
    private RenderedImage image;
    protected File lastDirectory;

    public ImageViewer(ImageViewer relatedViewer) {
        this();
        this.relatedViewer = relatedViewer;
    }

    public ImageViewer() {
        this.setLayout(new BorderLayout());
        JButton zoomIn = new JButton("Zoom in");
        JButton zoomOut = new JButton("Zoom out");
        final JToggleButton tileGrid = new JToggleButton("Tile grid");
        JButton save = new JButton("Save...");
        JButton showChain = new JButton("Show chain in separate window");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new FlowLayout(0));
        buttonBar.add(zoomIn);
        buttonBar.add(zoomOut);
        buttonBar.add(tileGrid);
        buttonBar.add(save);
        buttonBar.add(showChain);
        this.display = new ZoomableImageDisplay();
        tileGrid.setSelected(this.display.isTileGridVisible());
        this.status = new JLabel("Move on the image to display pixel values... ");
        this.add((Component)buttonBar, "North");
        this.add((Component)new JScrollPane(this.display), "Center");
        this.add((Component)this.status, "South");
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewer.this.display.setScale(ImageViewer.this.display.getScale() * 2.0);
                if (ImageViewer.this.relatedViewer != null) {
                    ImageViewer.this.relatedViewer.display.setScale(ImageViewer.this.relatedViewer.display.getScale() * 2.0);
                }
            }
        });
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewer.this.display.setScale(ImageViewer.this.display.getScale() / 2.0);
                if (ImageViewer.this.relatedViewer != null) {
                    ImageViewer.this.relatedViewer.display.setScale(ImageViewer.this.relatedViewer.display.getScale() / 2.0);
                }
            }
        });
        tileGrid.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImageViewer.this.display.setTileGridVisible(tileGrid.isSelected());
                if (ImageViewer.this.relatedViewer != null) {
                    ImageViewer.this.relatedViewer.display.setTileGridVisible(tileGrid.isSelected());
                }
            }
        });
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "*.png";
                    }

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".png");
                    }
                });
                int result = chooser.showSaveDialog(ImageViewer.this);
                if (result == 0) {
                    File selected = chooser.getSelectedFile();
                    if (!selected.getName().toLowerCase().endsWith(".png")) {
                        selected = new File(selected.getParentFile(), selected.getName() + ".png");
                    }
                    ImageViewer.this.lastDirectory = selected.getParentFile();
                    try {
                        ImageIO.write(ImageViewer.this.image, "PNG", selected);
                        ImageViewer.this.status.setText("File successfully saved");
                    }
                    catch (IOException e) {
                        ImageViewer.this.status.setText("Failed to save file: " + e.getMessage());
                    }
                }
            }
        });
        showChain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderedImageBrowser.showChain(ImageViewer.this.image);
            }
        });
        this.display.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ImageViewer.this.pixelIter != null) {
                    int x = (int)Math.round((double)e.getX() / ImageViewer.this.display.getScale());
                    int y = (int)Math.round((double)e.getY() / ImageViewer.this.display.getScale());
                    ImageViewer.this.sb.setLength(0);
                    if (x < ImageViewer.this.image.getMinX() || x >= ImageViewer.this.image.getMinX() + ImageViewer.this.image.getWidth() || y < ImageViewer.this.image.getMinY() || y >= ImageViewer.this.image.getMinY() + ImageViewer.this.image.getHeight()) {
                        ImageViewer.this.sb.append("Outside of image bounds");
                    } else {
                        ImageViewer.this.sb.append("Value at ");
                        ImageViewer.this.sb.append(x).append(", ").append(y).append(": [");
                        int dataType = ImageViewer.this.image.getSampleModel().getDataType();
                        if (dataType == 5 || dataType == 4) {
                            ImageViewer.this.pixelIter.getPixel(x, y, ImageViewer.this.dpixel);
                            for (int i = 0; i < ImageViewer.this.dpixel.length; ++i) {
                                ImageViewer.this.sb.append(ImageViewer.this.dpixel[i]);
                                if (i >= ImageViewer.this.dpixel.length - 1) continue;
                                ImageViewer.this.sb.append(", ");
                            }
                        } else {
                            ImageViewer.this.pixelIter.getPixel(x, y, ImageViewer.this.ipixel);
                            for (int i = 0; i < ImageViewer.this.ipixel.length; ++i) {
                                ImageViewer.this.sb.append(ImageViewer.this.ipixel[i]);
                                if (i >= ImageViewer.this.ipixel.length - 1) continue;
                                ImageViewer.this.sb.append(", ");
                            }
                        }
                        ImageViewer.this.sb.append(']');
                    }
                    ImageViewer.this.status.setText(ImageViewer.this.sb.toString());
                }
            }
        });
    }

    public void setImage(RenderedImage image) {
        this.image = image;
        if (image == null) {
            this.display.setVisible(false);
            this.pixelIter = null;
        } else {
            this.display.setImage(image);
            this.display.setVisible(true);
            this.pixelIter = RandomIterFactory.create(image, null);
            this.ipixel = new int[image.getSampleModel().getNumBands()];
            this.dpixel = new double[image.getSampleModel().getNumBands()];
        }
    }

    public ImageViewer getRelatedViewer() {
        return this.relatedViewer;
    }

    public void setRelatedViewer(ImageViewer relatedViewer) {
        this.relatedViewer = relatedViewer;
    }

    public void setStatusMessage(String message) {
        this.status.setText(message);
    }
}

