/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.I18N;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.IIOException;

public class TIFFDeflateDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    Inflater inflater = new Inflater();
    int predictor;

    public TIFFDeflateDecompressor(int predictor) throws IIOException {
        if (predictor != 1 && predictor != 2) {
            throw new IIOException("Illegal value for Predictor in TIFF file");
        }
        this.predictor = predictor;
    }

    @Override
    public synchronized void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        if (this.predictor == 2) {
            int len = this.bitsPerSample.length;
            int bps = this.bitsPerSample[0];
            if (bps != 8 && bps != 16) {
                throw new IIOException(bps + "-bit samples " + "are not supported for Horizontal " + "differencing Predictor");
            }
            for (int i = 0; i < len; ++i) {
                if (this.bitsPerSample[i] == bps) continue;
                throw new IIOException("Varying sample width is not supported for Horizontal differencing Predictor (first: " + bps + ", unexpected:" + this.bitsPerSample[i] + ")");
            }
        }
        this.stream.seek(this.offset);
        byte[] srcData = new byte[this.byteCount];
        this.stream.readFully(srcData);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        this.inflater.setInput(srcData);
        try {
            this.inflater.inflate(buf, bufOffset, bytesPerRow * this.srcHeight);
        }
        catch (DataFormatException dfe) {
            throw new IIOException(I18N.getString("TIFFDeflateDecompressor0"), dfe);
        }
        this.inflater.reset();
        if (this.predictor == 2) {
            int i;
            int count;
            int j;
            if (this.bitsPerSample[0] == 8) {
                for (j = 0; j < this.srcHeight; ++j) {
                    count = bufOffset + this.samplesPerPixel * (j * this.srcWidth + 1);
                    for (i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                        int n = count;
                        buf[n] = (byte)(buf[n] + buf[count - this.samplesPerPixel]);
                        ++count;
                    }
                }
            } else if (this.bitsPerSample[0] == 16) {
                int prev;
                int curr;
                if (this.stream.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                    for (j = 0; j < this.srcHeight; ++j) {
                        count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 2;
                        for (i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                            curr = (buf[count] & 0xFF) + (buf[count + 1] << 8);
                            prev = (buf[count - this.samplesPerPixel * 2] & 0xFF) + (buf[count + 1 - this.samplesPerPixel * 2] << 8);
                            buf[count] = (byte)(curr += prev);
                            buf[count + 1] = (byte)(curr >> 8);
                            count += 2;
                        }
                    }
                } else {
                    for (j = 0; j < this.srcHeight; ++j) {
                        count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 2;
                        for (i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                            curr = (buf[count + 1] & 0xFF) + (buf[count] << 8);
                            prev = (buf[count + 1 - this.samplesPerPixel * 2] & 0xFF) + (buf[count - this.samplesPerPixel * 2] << 8);
                            buf[count + 1] = (byte)(curr += prev);
                            buf[count] = (byte)(curr >> 8);
                            count += 2;
                        }
                    }
                }
            } else {
                throw new IIOException("Unexpected branch of Horizontal differencing Predictor, bps=" + this.bitsPerSample[0]);
            }
        }
        if (bytesPerRow != scanlineStride) {
            int off = 0;
            for (int y = 0; y < this.srcHeight; ++y) {
                System.arraycopy(buf, off, b, dstOffset, bytesPerRow);
                off += bytesPerRow;
                dstOffset += scanlineStride;
            }
        }
    }
}

