/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.curves;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;

public final class CircleArcMaker {
    private CircleArcMaker() {
    }

    public static Collection<Command> doCircleArc(List<Node> selectedNodes, List<Way> selectedWays, int angleSeparation) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        Node n1 = null;
        Node n2 = null;
        Node n3 = null;
        HashSet<Way> targetWays = new HashSet<Way>();
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        boolean nodesHaveBeenChoosen = false;
        if (selectedNodes.size() == 3) {
            Iterator<Node> nodeIter = selectedNodes.iterator();
            n1 = nodeIter.next();
            n2 = nodeIter.next();
            n3 = nodeIter.next();
            nodesHaveBeenChoosen = true;
            if (selectedWays.isEmpty()) {
                Way newWay = new Way();
                targetWays.add(newWay);
                cmds.add((Command)new AddCommand(ds, (OsmPrimitive)newWay));
                newWay.addNode(n1);
                newWay.addNode(n2);
                newWay.addNode(n3);
            }
        }
        if (!selectedWays.isEmpty()) {
            if (!nodesHaveBeenChoosen) {
                Way w = selectedWays.iterator().next();
                int nodeCount = w.getNodesCount();
                if (nodeCount < 3) {
                    return null;
                }
                n3 = w.getNode(nodeCount - 1);
                n2 = w.getNode(nodeCount - 2);
                n1 = w.getNode(nodeCount - 3);
                nodesHaveBeenChoosen = true;
            }
            List<Node> consideredNodes = Arrays.asList(n1, n2, n3);
            for (Way w : selectedWays) {
                final List nodes = w.getNodes();
                if (!nodes.containsAll(consideredNodes)) continue;
                Collections.sort(consideredNodes, new Comparator<Node>(){

                    @Override
                    public int compare(Node a, Node b) {
                        return nodes.indexOf(a) - nodes.indexOf(b);
                    }
                });
                n1 = consideredNodes.get(0);
                n2 = consideredNodes.get(1);
                n3 = consideredNodes.get(2);
                break;
            }
            for (Node n : consideredNodes) {
                targetWays.addAll(n.getParentWays());
            }
        }
        if (!nodesHaveBeenChoosen) {
            return null;
        }
        EastNorth p1 = n1.getEastNorth();
        EastNorth p2 = n2.getEastNorth();
        EastNorth p3 = n3.getEastNorth();
        ReturnValue<Integer> p2Index = new ReturnValue<Integer>();
        List<EastNorth> points = CircleArcMaker.circleArcPoints(p1, p2, p3, angleSeparation, false, p2Index);
        ArrayList<Node> arcNodes = new ArrayList<Node>(points.size());
        arcNodes.add(n1);
        int i = 1;
        for (EastNorth p : CircleArcMaker.slice(points, 1, -2)) {
            if (i == (Integer)p2Index.value) {
                Node n2new = new Node(n2);
                n2new.setEastNorth(p);
                arcNodes.add(n2);
                cmds.add((Command)new ChangeCommand((OsmPrimitive)n2, (OsmPrimitive)n2new));
            } else {
                Node n = new Node(p);
                arcNodes.add(n);
                cmds.add((Command)new AddCommand(ds, (OsmPrimitive)n));
            }
            ++i;
        }
        arcNodes.add(n3);
        Node[] anchorNodes = new Node[]{n1, n2, n3};
        CircleArcMaker.fuseArc(ds, anchorNodes, arcNodes, targetWays, cmds);
        return cmds;
    }

    private static void fuseArc(DataSet ds, Node[] anchorNodes, List<Node> arcNodes, Set<Way> targetWays, Collection<Command> cmds) {
        for (Way originalTw : targetWays) {
            Way tw = new Way(originalTw);
            boolean didChangeTw = false;
            for (int a = 0; a < 2; ++a) {
                int anchorBi = arcNodes.indexOf(anchorNodes[a]);
                int anchorEi = arcNodes.indexOf(anchorNodes[a + 1]);
                int bi = -1;
                int ei = -1;
                int i = -1;
                for (Node n : tw.getNodes()) {
                    ++i;
                    if (!Objects.equals(n, anchorNodes[a])) continue;
                    bi = i;
                    Node otherAnchor = anchorNodes[a + 1];
                    if (i > 0 && Objects.equals(tw.getNode(i - 1), otherAnchor)) {
                        ei = i - 1;
                        break;
                    }
                    if (i >= tw.getNodesCount() - 1 || !Objects.equals(tw.getNode(i + 1), otherAnchor)) continue;
                    ei = i + 1;
                    break;
                }
                if (bi == -1 || ei == -1) continue;
                didChangeTw = true;
                int twDirection = ei > bi ? 1 : 0;
                int anchorI = anchorBi + 1;
                int twI = bi + (twDirection == 1 ? 1 : 0);
                while (anchorI < anchorEi) {
                    tw.addNode(twI, arcNodes.get(anchorI));
                    ++anchorI;
                    twI += twDirection;
                }
            }
            if (!didChangeTw) continue;
            cmds.add((Command)new ChangeCommand(ds, (OsmPrimitive)originalTw, (OsmPrimitive)tw));
        }
    }

    private static List<EastNorth> circleArcPoints(EastNorth p1, EastNorth p2, EastNorth p3, int angleSeparation, boolean includeAnchors, ReturnValue<Integer> anchor2Index) {
        int indexJustBeforeP2;
        double x1 = p1.east();
        double y1 = p1.north();
        double x2 = p2.east();
        double y2 = p2.north();
        double x3 = p3.east();
        double y3 = p3.north();
        double s = 0.5 * ((x2 - x3) * (x1 - x3) - (y2 - y3) * (y3 - y1));
        double sUnder = (x1 - x2) * (y3 - y1) - (y2 - y1) * (x1 - x3);
        assert (sUnder != 0.0);
        double xc = 0.5 * (x1 + x2) + (s /= sUnder) * (y2 - y1);
        double yc = 0.5 * (y1 + y2) + s * (x1 - x2);
        double r = Math.sqrt(Math.pow(xc - x1, 2.0) + Math.pow(yc - y1, 2.0));
        double realA1 = CircleArcMaker.calcang(xc, yc, x1, y1);
        double realA2 = CircleArcMaker.calcang(xc, yc, x2, y2);
        double realA3 = CircleArcMaker.calcang(xc, yc, x3, y3);
        double startAngle = realA1;
        double a2 = CircleArcMaker.normalizeAngle(realA2 - startAngle);
        double a3 = CircleArcMaker.normalizeAngle(realA3 - startAngle);
        int direction = a3 > a2 ? 1 : -1;
        double radialLength = 0.0;
        if (direction == 1) {
            radialLength = a3;
        } else {
            radialLength = Math.PI * 2 - a3;
            a2 = Math.PI * 2 - a2;
            a3 = Math.PI * 2 - a3;
        }
        int numberOfNodesInArc = Math.max((int)Math.ceil(radialLength / Math.PI * 180.0 / (double)angleSeparation) + 1, 3);
        ArrayList<EastNorth> points = new ArrayList<EastNorth>(numberOfNodesInArc);
        double stepLength = radialLength / (double)(numberOfNodesInArc - 1);
        int closestIndexToP2 = indexJustBeforeP2 = (int)Math.floor(a2 / stepLength);
        if (a2 - (double)indexJustBeforeP2 * stepLength > (double)(indexJustBeforeP2 + 1) * stepLength - a2) {
            closestIndexToP2 = indexJustBeforeP2 + 1;
        }
        if (closestIndexToP2 == numberOfNodesInArc - 1) {
            --closestIndexToP2;
        } else if (closestIndexToP2 == 0) {
            ++closestIndexToP2;
        }
        assert (closestIndexToP2 != 0);
        double a = (double)direction * stepLength;
        points.add(p1);
        if (indexJustBeforeP2 == 0 && includeAnchors) {
            points.add(p2);
        }
        for (int i = 2; i < numberOfNodesInArc; ++i) {
            double nextA = (double)direction * ((double)i * stepLength);
            double realAngle = a + startAngle;
            double x = xc + r * Math.cos(realAngle);
            double y = yc + r * Math.sin(realAngle);
            points.add(new EastNorth(x, y));
            if (i - 1 == indexJustBeforeP2 && includeAnchors) {
                points.add(p2);
            }
            a = nextA;
        }
        points.add(p3);
        if (anchor2Index != null) {
            anchor2Index.value = closestIndexToP2;
        }
        return points;
    }

    private static <T> List<T> slice(List<T> list, int from, int to) {
        if (to < 0) {
            to += list.size() + 1;
        }
        return list.subList(from, to);
    }

    private static double normalizeAngle(double angle) {
        double PI2 = Math.PI * 2;
        if (angle < 0.0) {
            angle += (Math.floor(-angle / PI2) + 1.0) * PI2;
        } else if (angle >= PI2) {
            angle -= Math.floor(angle / PI2) * PI2;
        }
        return angle;
    }

    private static double calcang(double xc, double yc, double x, double y) {
        if (xc == x && yc == y) {
            return 0.0;
        }
        double yd = Math.abs(y - yc);
        if (yd == 0.0 && xc < x) {
            return 0.0;
        }
        if (yd == 0.0 && xc > x) {
            return Math.PI;
        }
        double xd = Math.abs(x - xc);
        double a = Math.atan2(xd, yd);
        if (y > yc) {
            a = Math.PI - a;
        }
        if (x < xc) {
            a = -a;
        }
        if ((a = 4.71238898038469 + a) < 0.0) {
            a += Math.PI * 2;
        }
        if (a >= Math.PI * 2) {
            a -= Math.PI * 2;
        }
        return a;
    }

    public static class ReturnValue<T> {
        public T value;
    }
}

