/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.awt.Component;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.plugins.buildings_tools.MyDialog;
import org.openstreetmap.josm.plugins.buildings_tools.ToolSettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedSettingsDialog
extends MyDialog {
    private final TagEditorModel tagsModel = new TagEditorModel();
    private final JCheckBox cBigMode = new JCheckBox(I18n.tr((String)"Big buildings mode", (Object[])new Object[0]));
    private final JCheckBox cSoftCur = new JCheckBox(I18n.tr((String)"Rotate crosshair", (Object[])new Object[0]));

    public AdvancedSettingsDialog() {
        super(I18n.tr((String)"Advanced settings", (Object[])new Object[0]));
        this.panel.add((Component)new JLabel(I18n.tr((String)"Buildings tags:", (Object[])new Object[0])), GBC.eol().fill(2));
        for (Map.Entry<String, String> entry : ToolSettings.getTags().entrySet()) {
            this.tagsModel.add(entry.getKey(), entry.getValue());
        }
        this.panel.add((Component)new TagEditorPanel(this.tagsModel, null, 255), GBC.eop().fill(1));
        this.panel.add((Component)this.cBigMode, GBC.eol().fill(2));
        this.panel.add((Component)this.cSoftCur, GBC.eol().fill(2));
        this.cBigMode.setSelected(ToolSettings.isBBMode());
        this.cSoftCur.setSelected(ToolSettings.isSoftCursor());
        this.setupDialog();
        this.showDialog();
    }

    public final void saveSettings() {
        ToolSettings.saveTags(this.tagsModel.getTags());
        ToolSettings.setBBMode(this.cBigMode.isSelected());
        ToolSettings.setSoftCursor(this.cSoftCur.isSelected());
    }
}

