/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;

public class PhotoAdjustWorker {
    private ImageEntry dragPhoto;
    private ImageData dragData;
    private Point2D dragOffset;
    private boolean centerViewIsDisabled = false;
    private boolean centerViewNeedsEnable = false;

    public void reset() {
        this.dragPhoto = null;
        this.dragData = null;
        this.dragOffset = null;
    }

    public synchronized void disableCenterView() {
        if (!this.centerViewIsDisabled && ImageViewerDialog.isCenterView()) {
            this.centerViewIsDisabled = true;
            this.centerViewNeedsEnable = ImageViewerDialog.setCentreEnabled((boolean)false);
        }
    }

    public synchronized void restoreCenterView() {
        if (this.centerViewIsDisabled) {
            if (this.centerViewNeedsEnable) {
                this.centerViewNeedsEnable = false;
                ImageViewerDialog.setCentreEnabled((boolean)true);
            }
            this.centerViewIsDisabled = false;
        }
    }

    public void doMousePressed(MouseEvent evt, List<GeoImageLayer> imageLayers) {
        block7: {
            boolean isCtrl;
            this.reset();
            if (evt.getButton() != 1 || imageLayers == null || imageLayers.isEmpty()) break block7;
            boolean isShift = (evt.getModifiers() & 1) != 0;
            boolean bl = isCtrl = (evt.getModifiers() & 2) != 0;
            if (isShift || isCtrl) {
                for (GeoImageLayer layer : imageLayers) {
                    ImageEntry img;
                    if (!layer.isVisible() || (img = layer.getImageData().getSelectedImage()) == null) continue;
                    if (isCtrl) {
                        if (img.getPos() != null) {
                            this.changeDirection(img, layer.getImageData(), evt);
                        }
                    } else {
                        this.movePhoto(img, layer.getImageData(), evt);
                    }
                    this.dragPhoto = img;
                    this.dragData = layer.getImageData();
                    break;
                }
            } else {
                for (GeoImageLayer layer : imageLayers) {
                    if (!layer.isVisible()) continue;
                    this.dragPhoto = layer.getPhotoUnderMouse(evt);
                    if (this.dragPhoto == null) continue;
                    this.dragData = layer.getImageData();
                    this.setDragOffset(this.dragPhoto, evt);
                    this.disableCenterView();
                    break;
                }
            }
        }
    }

    public void doMouseReleased(MouseEvent evt) {
        this.restoreCenterView();
    }

    public void doMouseDragged(MouseEvent evt) {
        if (this.dragData != null && this.dragPhoto != null) {
            if ((evt.getModifiers() & 2) != 0) {
                this.changeDirection(this.dragPhoto, this.dragData, evt);
            } else {
                this.disableCenterView();
                this.movePhoto(this.dragPhoto, this.dragData, evt);
            }
        }
    }

    private void setDragOffset(ImageEntry photo, MouseEvent evt) {
        Point2D centerPoint = MainApplication.getMap().mapView.getPoint2D((LatLon)photo.getPos());
        this.dragOffset = new Point2D.Double(centerPoint.getX() - (double)evt.getX(), centerPoint.getY() - (double)evt.getY());
    }

    private void movePhoto(ImageEntry photo, ImageData data, MouseEvent evt) {
        LatLon newPos = this.dragOffset != null ? MainApplication.getMap().mapView.getLatLon(this.dragOffset.getX() + (double)evt.getX(), this.dragOffset.getY() + (double)evt.getY()) : MainApplication.getMap().mapView.getLatLon(evt.getX(), evt.getY());
        data.updateImagePosition(photo, newPos);
    }

    private void changeDirection(ImageEntry photo, ImageData data, MouseEvent evt) {
        CachedLatLon photoLL = photo.getPos();
        if (photoLL == null) {
            return;
        }
        LatLon mouseLL = MainApplication.getMap().mapView.getLatLon(evt.getX(), evt.getY());
        double direction = photoLL.bearing(mouseLL) * 360.0 / 2.0 / Math.PI;
        if (direction < 0.0) {
            direction += 360.0;
        } else if (direction >= 360.0) {
            direction -= 360.0;
        }
        data.updateImageDirection(photo, direction);
        this.setDragOffset(photo, evt);
    }
}

