/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.pdfimport.DuplicateNodesFinder;
import org.openstreetmap.josm.plugins.pdfimport.LayerContents;
import org.openstreetmap.josm.plugins.pdfimport.LayerInfo;
import org.openstreetmap.josm.plugins.pdfimport.OrthogonalShapesFilter;
import org.openstreetmap.josm.plugins.pdfimport.ParallelSegmentsFinder;
import org.openstreetmap.josm.plugins.pdfimport.PdfMultiPath;
import org.openstreetmap.josm.plugins.pdfimport.PdfPath;

public class PathOptimizer {
    public List<Point2D> uniquePoints;
    public Map<Point2D, Point2D> uniquePointMap = new HashMap<Point2D, Point2D>();
    private final Map<LayerInfo, LayerContents> layerMap;
    private List<LayerContents> layers;
    public Rectangle2D bounds;
    private final double pointsTolerance;
    private final Color color;
    boolean splitOnColorChange;
    LayerContents prevLayer = null;

    public PathOptimizer(double _pointsTolerance, Color _color, boolean _splitOnColorChange) {
        this.uniquePoints = new ArrayList<Point2D>();
        this.layerMap = new HashMap<LayerInfo, LayerContents>();
        this.layers = new ArrayList<LayerContents>();
        this.pointsTolerance = _pointsTolerance;
        this.color = _color;
        this.splitOnColorChange = _splitOnColorChange;
    }

    public Point2D getUniquePoint(Point2D point) {
        if (this.uniquePointMap.containsKey(point)) {
            return this.uniquePointMap.get(point);
        }
        this.uniquePointMap.put(point, point);
        this.uniquePoints.add(point);
        return point;
    }

    public void addPath(LayerInfo info, PdfPath path) {
        if (!this.isColorOK(info)) {
            return;
        }
        LayerContents layer = this.getLayer(info);
        layer.paths.add(path);
    }

    public void addMultiPath(LayerInfo info, List<PdfPath> paths) {
        if (!this.isColorOK(info)) {
            return;
        }
        LayerContents layer = this.getLayer(info);
        HashSet<Point2D> points = new HashSet<Point2D>();
        for (PdfPath path : paths) {
            points.addAll(path.points);
        }
        LayerContents multipathLayer = new LayerContents();
        multipathLayer.paths = paths;
        Map<Point2D, Point2D> pointMap = DuplicateNodesFinder.findDuplicateNodes(points, this.pointsTolerance);
        this.fixPoints(multipathLayer, pointMap);
        this.concatenatePaths(multipathLayer);
        paths = multipathLayer.paths;
        boolean goodMultiPath = true;
        for (PdfPath path : paths) {
            goodMultiPath &= path.isClosed();
        }
        if (goodMultiPath) {
            PdfMultiPath p = new PdfMultiPath(paths);
            layer.multiPaths.add(p);
        } else {
            layer.paths.addAll(paths);
        }
    }

    private boolean isColorOK(LayerInfo info) {
        if (this.color == null) {
            return true;
        }
        int rgb = this.color.getRGB() & 0xFFFFFF;
        boolean good = false;
        if (info.fill != null && (info.fill.getRGB() & 0xFFFFFF) == rgb) {
            good = true;
        }
        if (info.stroke != null && (info.stroke.getRGB() & 0xFFFFFF) == rgb) {
            good = true;
        }
        return good;
    }

    public void removeParallelLines(double maxDistance) {
        for (LayerContents layer : this.layers) {
            this.removeParallelLines(layer, maxDistance);
        }
    }

    public void mergeNodes() {
        Map<Point2D, Point2D> pointMap = DuplicateNodesFinder.findDuplicateNodes(this.uniquePoints, this.pointsTolerance);
        for (LayerContents layer : this.layers) {
            this.fixPoints(layer, pointMap);
        }
    }

    public void mergeSegments() {
        for (LayerContents layer : this.layers) {
            this.concatenatePaths(layer);
        }
    }

    public void removeSmallObjects(double tolerance) {
        for (LayerContents layer : this.layers) {
            this.removeSmallObjects(layer, tolerance, Double.POSITIVE_INFINITY);
        }
    }

    public void removeLargeObjects(double tolerance) {
        for (LayerContents layer : this.layers) {
            this.removeSmallObjects(layer, 0.0, tolerance);
        }
    }

    public void splitLayersBySimilarShapes(double tolerance) {
        ArrayList<LayerContents> newLayers = new ArrayList<LayerContents>();
        for (LayerContents l : this.layers) {
            List<LayerContents> splitResult = this.splitBySimilarGroups(l);
            for (LayerContents ll : splitResult) {
                newLayers.add(ll);
            }
        }
        this.layers = newLayers;
    }

    public void splitLayersByPathKind(boolean closed, boolean single, boolean orthogonal) {
        ArrayList<LayerContents> newLayers = new ArrayList<LayerContents>();
        for (LayerContents l : this.layers) {
            List<LayerContents> splitResult = this.splitBySegmentKind(l, closed, single, orthogonal);
            for (LayerContents ll : splitResult) {
                newLayers.add(ll);
            }
        }
        this.layers = newLayers;
    }

    public void finish() {
        int nr = 0;
        for (LayerContents layer : this.layers) {
            layer.info.nr = nr++;
            this.finalizeLayer(layer);
        }
    }

    private LayerContents getLayer(LayerInfo info) {
        LayerContents layer = null;
        if (this.layerMap.containsKey(info) && (layer = this.layerMap.get(info)) != this.prevLayer && this.splitOnColorChange) {
            layer = null;
        }
        if (layer == null) {
            layer = new LayerContents();
            layer.info = info.copy();
            layer.info.nr = this.layers.size();
            this.layerMap.put(layer.info, layer);
            this.layers.add(layer);
        }
        this.prevLayer = layer;
        return layer;
    }

    private void finalizeLayer(LayerContents layer) {
        HashSet<Point2D> points = new HashSet<Point2D>();
        layer.points = new ArrayList<Point2D>();
        for (PdfPath pp : layer.paths) {
            pp.layer = layer;
            for (Point2D point : pp.points) {
                if (points.contains(point)) continue;
                layer.points.add(point);
                points.add(point);
            }
        }
        for (PdfMultiPath multipath : layer.multiPaths) {
            multipath.layer = layer;
            for (PdfPath pp : multipath.paths) {
                pp.layer = layer;
                for (Point2D point : pp.points) {
                    if (points.contains(point)) continue;
                    layer.points.add(point);
                    points.add(point);
                }
            }
        }
    }

    private void fixPoints(LayerContents layer, Map<Point2D, Point2D> pointMap) {
        ArrayList<PdfPath> newPaths = new ArrayList<PdfPath>(layer.paths.size());
        for (PdfPath path : layer.paths) {
            List<Point2D> points = this.fixPoints(path.points, pointMap);
            path.points = points;
            if (points.size() <= 2 && (path.isClosed() || points.size() <= 1)) continue;
            newPaths.add(path);
        }
        layer.paths = newPaths;
        for (PdfMultiPath mp : layer.multiPaths) {
            for (PdfPath path : mp.paths) {
                path.points = this.fixPoints(path.points, pointMap);
            }
        }
    }

    private List<Point2D> fixPoints(List<Point2D> points, Map<Point2D, Point2D> pointMap) {
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>(points.size());
        Point2D prevPoint = null;
        Iterator<Point2D> iterator = points.iterator();
        while (iterator.hasNext()) {
            Point2D p;
            Point2D pp = p = iterator.next();
            if (pointMap.containsKey(p)) {
                pp = pointMap.get(p);
            }
            if (prevPoint != pp) {
                newPoints.add(pp);
            }
            prevPoint = pp;
        }
        return newPoints;
    }

    private void removeSmallObjects(LayerContents layer, double min, double max) {
        ArrayList<PdfPath> newPaths = new ArrayList<PdfPath>(layer.paths.size());
        for (PdfPath path : layer.paths) {
            boolean good;
            double size = this.getShapeSize(path);
            boolean bl = good = size >= min && size <= max;
            if (!good) continue;
            newPaths.add(path);
        }
        layer.paths = newPaths;
        ArrayList<PdfMultiPath> newMPaths = new ArrayList<PdfMultiPath>(layer.multiPaths.size());
        for (PdfMultiPath mp : layer.multiPaths) {
            boolean good = true;
            for (PdfPath path : mp.paths) {
                double size = this.getShapeSize(path);
                good &= size >= min && size <= max;
            }
            if (!good) continue;
            newMPaths.add(mp);
        }
        layer.multiPaths = newMPaths;
    }

    private double getShapeSize(PdfPath path) {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(path.points.get(0).getX(), path.points.get(0).getY(), 0.0, 0.0);
        for (Point2D n : path.points) {
            bounds.add(n);
        }
        return Math.max(((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
    }

    private void removeParallelLines(LayerContents layer, double maxDistance) {
        double angleTolerance = Math.PI / 180;
        int minSegments = 10;
        ArrayList<ParallelSegmentsFinder> angles = new ArrayList<ParallelSegmentsFinder>();
        for (PdfPath path : layer.paths) {
            ParallelSegmentsFinder pa2;
            if (path.points.size() != 2) continue;
            Point2D p1 = path.firstPoint();
            Point2D p2 = path.lastPoint();
            double angle = Math.atan2(p2.getX() - p1.getX(), p2.getY() - p1.getY());
            while (angle < 0.0) {
                angle += Math.PI;
            }
            while (angle > Math.PI) {
                angle -= Math.PI;
            }
            boolean added = false;
            for (ParallelSegmentsFinder pa2 : angles) {
                if (!(Math.abs(pa2.angle - angle) < angleTolerance)) continue;
                pa2.addPath(path, angle);
                added = true;
                break;
            }
            if (added) continue;
            pa2 = new ParallelSegmentsFinder();
            pa2.addPath(path, angle);
            angles.add(pa2);
        }
        HashSet<PdfPath> pathsToRemove = new HashSet<PdfPath>();
        for (ParallelSegmentsFinder pa : angles) {
            if (pa.paths.size() < minSegments) continue;
            List<ParallelSegmentsFinder> parts = pa.splitByDistance(maxDistance);
            for (ParallelSegmentsFinder part : parts) {
                if (part.paths.size() < minSegments) continue;
                pathsToRemove.addAll(part.paths);
            }
        }
        ArrayList<PdfPath> result = new ArrayList<PdfPath>(layer.paths.size() - pathsToRemove.size());
        for (PdfPath path : layer.paths) {
            if (pathsToRemove.contains(path)) continue;
            result.add(path);
        }
        layer.paths = result;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void concatenatePaths(LayerContents layer) {
        pathEndpoints = new HashMap<Point2D, List<E>>();
        mergedPaths = new HashSet<PdfPath>();
        newPaths = new ArrayList<PdfPath>();
        for (PdfPath pp : layer.paths) {
            if (pp.isClosed()) {
                newPaths.add(pp);
                continue;
            }
            paths = (ArrayList<PdfPath>)pathEndpoints.get(pp.firstPoint());
            if (paths == null) {
                paths = new ArrayList<PdfPath>(2);
                pathEndpoints.put(pp.firstPoint(), paths);
            }
            paths.add(pp);
            paths = (List)pathEndpoints.get(pp.lastPoint());
            if (paths == null) {
                paths = new ArrayList<E>(2);
                pathEndpoints.put(pp.lastPoint(), paths);
            }
            paths.add(pp);
        }
        pathChain = new ArrayList<Object>(2);
        pointsInPath = new HashSet<Point2D>();
        for (PdfPath pp : layer.paths) {
            if (pp.isClosed() || mergedPaths.contains(pp)) continue;
            changed = true;
            firstPath = pp;
            lastPath = pp;
            firstPoint = pp.firstPoint();
            lastPoint = pp.lastPoint();
            pathChain.clear();
            pathChain.add(pp);
            pointsInPath.clear();
            pointsInPath.add(firstPoint);
            pointsInPath.add(lastPoint);
            while (changed && firstPoint != lastPoint) {
                changed = false;
                adjacentPaths = (List)pathEndpoints.get(lastPoint);
                nextPath = this.findNextPath(adjacentPaths, (PdfPath)lastPath);
                if (nextPath == null) continue;
                lastPoint = nextPoint = nextPath.getOtherEnd(lastPoint);
                lastPath = nextPath;
                pathChain.add(lastPath);
                if (pointsInPath.contains(lastPoint)) ** GOTO lbl57
                pointsInPath.add(lastPoint);
                changed = true;
                continue;
lbl-1000:
                // 1 sources

                {
                    pathToRemove = (PdfPath)pathChain.remove(0);
                    firstPoint = pathToRemove.getOtherEnd(firstPoint);
lbl57:
                    // 2 sources

                    ** while (lastPoint != firstPoint)
                }
lbl58:
                // 1 sources

                changed = false;
            }
            changed = true;
            while (changed && firstPoint != lastPoint) {
                changed = false;
                adjacentPaths = (List)pathEndpoints.get(firstPoint);
                nextPath = this.findNextPath(adjacentPaths, (PdfPath)firstPath);
                if (nextPath == null) continue;
                firstPoint = nextPoint = nextPath.getOtherEnd(firstPoint);
                firstPath = nextPath;
                pathChain.add(0, firstPath);
                if (pointsInPath.contains(firstPoint)) ** GOTO lbl76
                pointsInPath.add(firstPoint);
                changed = true;
                continue;
lbl-1000:
                // 1 sources

                {
                    pathToRemove = (PdfPath)pathChain.remove(pathChain.size() - 1);
                    lastPoint = pathToRemove.getOtherEnd(lastPoint);
lbl76:
                    // 2 sources

                    ** while (lastPoint != firstPoint)
                }
lbl77:
                // 1 sources

                changed = false;
            }
            for (PdfPath path : pathChain) {
                ((List)pathEndpoints.get(path.firstPoint())).remove(path);
                ((List)pathEndpoints.get(path.lastPoint())).remove(path);
                mergedPaths.add(path);
            }
            path = (PdfPath)pathChain.get(0);
            pos = 1;
            while (pos < pathChain.size()) {
                path.points = this.tryMergeNodeLists(path.points, ((PdfPath)pathChain.get((int)pos)).points);
                if (path.points == null) {
                    throw new RuntimeException();
                }
                ++pos;
            }
            newPaths.add(path);
        }
        layer.paths = newPaths;
    }

    private PdfPath findNextPath(List<PdfPath> adjacentPaths, PdfPath firstPath) {
        int pos = 0;
        while (pos < adjacentPaths.size()) {
            PdfPath p = adjacentPaths.get(pos);
            if (p != firstPath && !this.isSubpathOf(firstPath, p)) {
                return p;
            }
            ++pos;
        }
        return null;
    }

    private boolean isSubpathOf(PdfPath main, PdfPath sub) {
        HashSet<Point2D> points = new HashSet<Point2D>(main.points);
        for (Point2D point : sub.points) {
            if (points.contains(point)) continue;
            return false;
        }
        return true;
    }

    private List<LayerContents> splitBySegmentKind(LayerContents layer, boolean closed, boolean single, boolean orthogonal) {
        LayerContents l;
        if (!closed && !single) {
            return Collections.singletonList(layer);
        }
        OrthogonalShapesFilter of = new OrthogonalShapesFilter(10.0);
        ArrayList<PdfPath> singleSegmentPaths = new ArrayList<PdfPath>();
        ArrayList<PdfPath> multiSegmentPaths = new ArrayList<PdfPath>();
        ArrayList<PdfPath> closedPaths = new ArrayList<PdfPath>();
        ArrayList<PdfPath> orthogonalPaths = new ArrayList<PdfPath>();
        ArrayList<PdfPath> orthogonalClosedPaths = new ArrayList<PdfPath>();
        for (PdfPath path : layer.paths) {
            boolean pathSingleSegment;
            boolean pathOrthgonal = orthogonal && of.isOrthogonal(path);
            boolean pathUnclosed = !path.isClosed() && closed;
            boolean bl = pathSingleSegment = path.points.size() <= 3 && single;
            if (pathSingleSegment) {
                singleSegmentPaths.add(path);
                continue;
            }
            if (pathUnclosed) {
                if (pathOrthgonal) {
                    orthogonalPaths.add(path);
                    continue;
                }
                multiSegmentPaths.add(path);
                continue;
            }
            if (pathOrthgonal) {
                orthogonalClosedPaths.add(path);
                continue;
            }
            closedPaths.add(path);
        }
        ArrayList<LayerContents> layers = new ArrayList<LayerContents>();
        if (multiSegmentPaths.size() > 0) {
            l = new LayerContents();
            l.paths = multiSegmentPaths;
            l.info = layer.info.copy();
            layers.add(l);
        }
        if (singleSegmentPaths.size() > 0) {
            l = new LayerContents();
            l.paths = singleSegmentPaths;
            l.info = layer.info.copy();
            layers.add(l);
        }
        if (orthogonalPaths.size() > 0) {
            l = new LayerContents();
            l.paths = orthogonalPaths;
            l.info = layer.info.copy();
            layers.add(l);
        }
        if (orthogonalClosedPaths.size() > 0) {
            l = new LayerContents();
            l.paths = orthogonalClosedPaths;
            l.info = layer.info.copy();
            layers.add(l);
        }
        if (closedPaths.size() > 0 || layer.multiPaths.size() > 0) {
            l = new LayerContents();
            l.paths = closedPaths;
            l.info = layer.info.copy();
            l.multiPaths = layer.multiPaths;
            layers.add(l);
        }
        return layers;
    }

    private List<LayerContents> splitBySimilarGroups(LayerContents layer) {
        ArrayList subparts = new ArrayList();
        for (PdfPath path : layer.paths) {
            List<PdfPath> sublayer = null;
            for (List list : subparts) {
                if (!this.pathsSimilar(((PdfPath)list.get((int)0)).points, path.points)) continue;
                sublayer = list;
                break;
            }
            if (sublayer == null) {
                sublayer = new ArrayList<PdfPath>();
                subparts.add(sublayer);
            }
            sublayer.add(path);
        }
        int minGroupTreshold = 10;
        ArrayList<PdfPath> independantPaths = new ArrayList<PdfPath>();
        ArrayList<LayerContents> result = new ArrayList<LayerContents>();
        for (List list : subparts) {
            if (list.size() >= minGroupTreshold) {
                LayerContents l = new LayerContents();
                l.paths = list;
                l.info = layer.info.copy();
                l.info.isGroup = true;
                l.multiPaths = Collections.emptyList();
                result.add(l);
                continue;
            }
            independantPaths.addAll(list);
        }
        if (independantPaths.size() > 0 || layer.multiPaths.size() > 0) {
            LayerContents layerContents = new LayerContents();
            layerContents.paths = independantPaths;
            layerContents.info = layer.info.copy();
            layerContents.info.isGroup = false;
            layerContents.multiPaths = layer.multiPaths;
            result.add(layerContents);
        }
        return result;
    }

    private List<Point2D> tryMergeNodeLists(List<Point2D> nodes1, List<Point2D> nodes2) {
        boolean nodes2Closed;
        boolean nodes1Closed = nodes1.get(0) == nodes1.get(nodes1.size() - 1);
        boolean bl = nodes2Closed = nodes2.get(0) == nodes2.get(nodes2.size() - 1);
        if (nodes1Closed || nodes2Closed) {
            return null;
        }
        if (nodes1.get(nodes1.size() - 1) == nodes2.get(0)) {
            nodes1.remove(nodes1.size() - 1);
            nodes1.addAll(nodes2);
            return nodes1;
        }
        if (nodes1.get(nodes1.size() - 1) == nodes2.get(nodes2.size() - 1)) {
            nodes1.remove(nodes1.size() - 1);
            int pos = nodes2.size() - 1;
            while (pos >= 0) {
                nodes1.add(nodes2.get(pos));
                --pos;
            }
            return nodes1;
        }
        if (nodes1.get(0) == nodes2.get(nodes2.size() - 1)) {
            nodes1.remove(0);
            nodes1.addAll(0, nodes2);
            return nodes1;
        }
        if (nodes1.get(0) == nodes2.get(0)) {
            nodes1.remove(0);
            int pos = 0;
            while (pos < nodes2.size()) {
                nodes1.add(0, nodes2.get(pos));
                ++pos;
            }
            return nodes1;
        }
        return null;
    }

    public List<LayerContents> getLayers() {
        return this.layers;
    }

    private boolean pathsSimilar(List<Point2D> path1, List<Point2D> path2) {
        if (path1.size() != path2.size()) {
            return false;
        }
        if (path1.size() < 3) {
            return false;
        }
        Point2D p1 = path1.get(0);
        Point2D p2 = path2.get(0);
        double offsetX = p1.getX() - p2.getX();
        double offsetY = p1.getY() - p2.getY();
        double tolerance = 1.0E-4;
        int pos = 0;
        while (pos < path1.size()) {
            p1 = path1.get(pos);
            p2 = path2.get(pos);
            double errorX = p1.getX() - p2.getX() - offsetX;
            double errorY = p1.getY() - p2.getY() - offsetY;
            if (Math.abs(errorX) + Math.abs(errorY) > tolerance) {
                return false;
            }
            ++pos;
        }
        return true;
    }
}

