/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.geom.Point2D;
import org.openstreetmap.josm.plugins.pdfimport.PdfPath;

public class OrthogonalShapesFilter {
    private double tolerance;

    public OrthogonalShapesFilter(double toleranceDegrees) {
        this.tolerance = Math.toRadians(toleranceDegrees);
    }

    public boolean isOrthogonal(PdfPath path) {
        if (path.points.size() < 3) {
            return false;
        }
        int targetPos = path.isClosed() ? path.points.size() : path.points.size() - 1;
        int pos = 1;
        while (pos < targetPos) {
            Point2D p1 = path.points.get(pos - 1);
            Point2D p2 = path.points.get(pos);
            Point2D p3 = pos + 1 == path.points.size() ? path.points.get(1) : path.points.get(pos + 1);
            double angle1 = Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX());
            double angle2 = Math.atan2(p3.getY() - p2.getY(), p3.getX() - p2.getX());
            double angleDifference = angle1 - angle2;
            while (angleDifference < 0.0) {
                angleDifference += Math.PI;
            }
            boolean hasGoodVariant = false;
            int quadrant = 0;
            while (quadrant <= 4) {
                double difference = angleDifference - 1.5707963267948966 * (double)quadrant;
                if (Math.abs(difference) <= this.tolerance) {
                    hasGoodVariant = true;
                }
                ++quadrant;
            }
            if (!hasGoodVariant) {
                return false;
            }
            ++pos;
        }
        return true;
    }
}

