/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.boilerplate;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideColorScheme;

public class StreetsideButton
extends JButton {
    private static final long serialVersionUID = -3060978712233067368L;

    public StreetsideButton(Action action) {
        this(action, false);
    }

    public StreetsideButton(Action action, boolean slim) {
        super(action);
        this.setForeground(Color.WHITE);
        this.setBorder(slim ? BorderFactory.createEmptyBorder(3, 4, 3, 4) : BorderFactory.createEmptyBorder(7, 10, 7, 10));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isEnabled()) {
            g.setColor(StreetsideColorScheme.TOOLBAR_DARK_GREY);
        } else if (this.getModel().isPressed()) {
            g.setColor(StreetsideColorScheme.STREETSIDE_BLUE.darker().darker());
        } else if (this.getModel().isRollover()) {
            g.setColor(StreetsideColorScheme.STREETSIDE_BLUE.darker());
        } else {
            g.setColor(StreetsideColorScheme.STREETSIDE_BLUE);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 3, 3);
        super.paintComponent(g);
    }

    @Override
    public boolean isContentAreaFilled() {
        return false;
    }
}

