/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.tools.I18n;

public class StreetsideExportDialog
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2746815082016025516L;
    public final JRadioButton all;
    public final JRadioButton sequence;
    public final JRadioButton selected;
    public final ButtonGroup group;
    private final JButton choose;
    private final JLabel path;
    public JFileChooser chooser;
    private final JButton ok;

    public StreetsideExportDialog(JButton ok) {
        this.ok = ok;
        ok.setEnabled(false);
        this.setLayout(new BoxLayout(this, 3));
        RewriteButtonAction action = new RewriteButtonAction(this);
        this.group = new ButtonGroup();
        this.all = new JRadioButton(action);
        this.all.setText(I18n.tr((String)"Export all images", (Object[])new Object[0]));
        this.sequence = new JRadioButton(action);
        this.sequence.setText(I18n.tr((String)"Export selected sequence", (Object[])new Object[0]));
        this.selected = new JRadioButton(action);
        this.selected.setText(I18n.tr((String)"Export selected images", (Object[])new Object[0]));
        this.group.add(this.all);
        this.group.add(this.sequence);
        this.group.add(this.selected);
        this.sequence.setEnabled(StreetsideLayer.getInstance().getData().getSelectedImage() instanceof StreetsideImage);
        if (StreetsideLayer.getInstance().getData().getMultiSelectedImages().isEmpty()) {
            this.selected.setEnabled(false);
        }
        this.path = new JLabel(I18n.tr((String)"Select a directory", (Object[])new Object[0]));
        this.choose = new JButton(I18n.tr((String)"Explore", (Object[])new Object[0]));
        this.choose.addActionListener(this);
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BoxLayout(jpanel, 3));
        jpanel.add(this.all);
        jpanel.add(this.sequence);
        jpanel.add(this.selected);
        jpanel.setAlignmentX(0.5f);
        this.path.setAlignmentX(0.5f);
        this.choose.setAlignmentX(0.5f);
        this.add(jpanel);
        this.add(this.path);
        this.add(this.choose);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        this.chooser.setDialogTitle(I18n.tr((String)"Select a directory", (Object[])new Object[0]));
        this.chooser.setFileSelectionMode(1);
        this.chooser.setAcceptAllFileFilterUsed(false);
        if (this.chooser.showOpenDialog(this) == 0) {
            this.path.setText(this.chooser.getSelectedFile().toString());
            this.updateUI();
            this.ok.setEnabled(true);
        }
    }

    public class RewriteButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1035332841101190301L;
        private String lastPath;
        private final StreetsideExportDialog dlg;

        public RewriteButtonAction(StreetsideExportDialog dlg) {
            this.dlg = dlg;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            StreetsideExportDialog.this.choose.setEnabled(true);
            if (this.lastPath != null) {
                this.dlg.path.setText(this.lastPath);
            }
        }
    }
}

