/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cache;

import java.net.URL;
import java.util.HashMap;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.imagery.TileJobOptions;
import org.openstreetmap.josm.plugins.streetside.cache.Caches;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;

public class StreetsideCache
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry> {
    private final URL url;
    private final String id;

    public StreetsideCache(String id, Type type) {
        super(Caches.ImageCache.getInstance().getCache(), new TileJobOptions(50000, 50000, new HashMap(), 50000L));
        if (id == null || type == null) {
            this.id = null;
            this.url = null;
        } else {
            this.id = id;
            this.url = StreetsideURL.VirtualEarth.streetsideTile(id, type == Type.THUMBNAIL);
        }
    }

    public String getCacheKey() {
        return this.id;
    }

    public URL getUrl() {
        return this.url;
    }

    protected BufferedImageCacheEntry createCacheEntry(byte[] content) {
        return new BufferedImageCacheEntry(content);
    }

    protected boolean isObjectLoadable() {
        if (this.cacheData == null) {
            return false;
        }
        byte[] content = ((BufferedImageCacheEntry)this.cacheData).getContent();
        return content != null && content.length > 0;
    }

    public static enum Type {
        FULL_IMAGE,
        THUMBNAIL;

    }
}

