/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MiddleNodesAction
extends JosmAction {
    public static final boolean treeMode = false;

    public MiddleNodesAction() {
        super(I18n.tr((String)"Middle nodes", (Object[])new Object[0]), "midnodes", I18n.tr((String)"Select middle nodes", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:midnodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Middle nodes"}), (int)69, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/MiddleNodes"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        Set selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        if (selectedNodes.size() != 2) {
            new Notification(I18n.tr((String)"Please select two nodes connected by way!", (Object[])new Object[0])).setIcon(2).show();
            return;
        }
        HashSet<Node> newNodes = new HashSet<Node>();
        NodeWayUtils.addMiddle(selectedNodes, newNodes);
        newNodes.removeAll(selectedNodes);
        this.getLayerManager().getEditDataSet().addSelected(newNodes);
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

